/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import io.intercom.android.sdk.models.Avatar;

public class User
implements Parcelable {
    @SerializedName(value="intercom_id")
    private final String intercomId;
    @SerializedName(value="anonymous_id")
    private final String anonymousId;
    @SerializedName(value="user_id")
    private final String userId;
    private final String name;
    private final String email;
    private final String type;
    public static final Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>(){

        public User createFromParcel(Parcel in) {
            return new User(in);
        }

        public User[] newArray(int size) {
            return new User[size];
        }
    };

    public User() {
        this("");
    }

    public User(String intercomId) {
        this.type = "user";
        this.intercomId = intercomId;
        this.anonymousId = "";
        this.userId = "";
        this.name = "";
        this.email = "";
    }

    private User(Builder builder) {
        this.type = builder.type == null ? "user" : builder.type;
        this.intercomId = builder.intercom_id == null ? "" : builder.intercom_id;
        this.anonymousId = builder.anonymous_id == null ? "" : builder.anonymous_id;
        this.userId = builder.user_id == null ? "" : builder.user_id;
        this.name = builder.name == null ? "" : builder.name;
        this.email = builder.email == null ? "" : builder.email;
    }

    protected User(Parcel in) {
        this.type = in.readString();
        this.intercomId = in.readString();
        this.anonymousId = in.readString();
        this.userId = in.readString();
        this.name = in.readString();
        this.email = in.readString();
    }

    public String getType() {
        return this.type;
    }

    public String getIntercomId() {
        return this.intercomId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User other = (User)obj;
            return this.intercomId.equals(other.intercomId);
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type);
        dest.writeString(this.intercomId);
        dest.writeString(this.anonymousId);
        dest.writeString(this.userId);
        dest.writeString(this.name);
        dest.writeString(this.email);
    }

    public static final class Builder {
        private String type;
        private String intercom_id;
        private String anonymous_id;
        private String user_id;
        private String name;
        private String email;
        private Avatar.Builder avatar;

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder intercomId(String intercomId) {
            this.intercom_id = intercomId;
            return this;
        }

        public Builder anonymousId(String anonymousId) {
            this.anonymous_id = anonymousId;
            return this;
        }

        public Builder userId(String userId) {
            this.user_id = userId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

