/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class RealTimeConfig {
    private List<String> endpoints;
    private int presenceHeartbeatInterval;
    private int connectionTimeout;

    public RealTimeConfig() {
        this(new Builder());
    }

    public RealTimeConfig(Builder builder) {
        this.endpoints = builder.endpoints == null ? new ArrayList() : builder.endpoints;
        this.presenceHeartbeatInterval = builder.presenceHeartbeatInterval;
        this.connectionTimeout = builder.connectionTimeout;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public int getPresenceHeartbeatInterval() {
        return this.presenceHeartbeatInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealTimeConfig that = (RealTimeConfig)o;
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.presenceHeartbeatInterval != that.presenceHeartbeatInterval) {
            return false;
        }
        return !(this.endpoints == null ? that.endpoints != null : !this.endpoints.equals(that.endpoints));
    }

    public int hashCode() {
        int result = this.endpoints != null ? this.endpoints.hashCode() : 0;
        result = 31 * result + this.presenceHeartbeatInterval;
        result = 31 * result + this.connectionTimeout;
        return result;
    }

    public static class Builder {
        private List<String> endpoints;
        @SerializedName(value="presence_heartbeat_interval")
        private int presenceHeartbeatInterval;
        @SerializedName(value="connection_timeout")
        private int connectionTimeout;

        public RealTimeConfig build() {
            return new RealTimeConfig(this);
        }
    }
}

