/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.graphics.Color;
import android.text.Html;
import android.text.method.MovementMethod;
import android.text.util.Linkify;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.utilities.TrackingLinkMovementMethod;
import io.intercom.blocks.blockInterfaces.ParagraphBlock;

public class Paragraph
implements ParagraphBlock {
    private final LayoutInflater inflater;
    private final StyleType style;
    private final Context context;

    public Paragraph(Context context, StyleType style) {
        this.style = style;
        this.inflater = LayoutInflater.from((Context)context);
        this.context = context;
    }

    public View addParagraph(String text, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        TextView textview;
        switch (this.style) {
            case admin: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_paragraph, parent, false);
                break;
            }
            case announcement: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_admin_paragraph, parent, false);
                break;
            }
            case welcome: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_welcome_paragraph, parent, false);
                break;
            }
            default: {
                textview = (TextView)this.inflater.inflate(R.layout.intercomsdk_blocks_user_paragraph, parent, false);
            }
        }
        textview.setClickable(true);
        textview.setMovementMethod((MovementMethod)new TrackingLinkMovementMethod());
        if (StyleType.preview == this.style) {
            textview.setLinkTextColor(-1);
            textview.setText((CharSequence)text);
            Linkify.addLinks((TextView)textview, (int)1);
            textview.setMovementMethod(TrackingLinkMovementMethod.getInstance());
        } else {
            if (StyleType.user == this.style) {
                textview.setLinkTextColor(-1);
            } else {
                textview.setLinkTextColor(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
            }
            textview.setText((CharSequence)Html.fromHtml((String)text));
        }
        if (isLastObject) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(textview.getLayoutParams());
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
            params.gravity = StyleType.welcome == this.style ? 17 : 0x800003;
            textview.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return textview;
    }
}

