/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.blocks;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.intercom.blocks.BlocksViewHolder;
import io.intercom.blocks.VideoProvider;
import io.intercom.blocks.models.Block;
import java.util.List;

public class Blocks
implements Parcelable {
    private final LayoutInflater inflater;
    public static final Parcelable.Creator<Blocks> CREATOR = new Parcelable.Creator<Blocks>(){

        public Blocks createFromParcel(Parcel in) {
            return new Blocks(in);
        }

        public Blocks[] newArray(int size) {
            return new Blocks[size];
        }
    };

    public Blocks(Context context) {
        this.inflater = LayoutInflater.from((Context)context);
    }

    public LinearLayout createBlocks(List<Block> body, BlocksViewHolder views) {
        LinearLayout layout = (LinearLayout)this.inflater.inflate(views.getLayout(), null);
        if (body != null) {
            block19: for (int i = 0; i < body.size(); ++i) {
                Block block = body.get(i);
                boolean isFirstObject = i == 0;
                boolean isLastObject = i == body.size() - 1;
                Type type = Type.valueOf("unknown");
                try {
                    type = Type.valueOf(block.getType());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                String url = block.getTrackingUrl() == null || block.getTrackingUrl().isEmpty() ? block.getLinkUrl() : block.getTrackingUrl();
                switch (type) {
                    case paragraph: {
                        layout.addView(views.getParagraph().addParagraph(block.getText(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case heading: {
                        layout.addView(views.getHeading().addHeading(block.getText(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case subheading: {
                        layout.addView(views.getSubheading().addSubheading(block.getText(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case unorderedList: {
                        layout.addView(views.getUnorderedList().addUnorderedList(block.getItems(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case orderedList: {
                        layout.addView(views.getOrderedList().addOrderedList(block.getItems(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case code: {
                        layout.addView(views.getCode().addCode(block.getText(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case image: {
                        layout.addView(views.getImage().addImage(block.getUrl(), url, isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case lwr: {
                        layout.addView(views.getLwr().addLWR(block.getText(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case button: {
                        layout.addView(views.getButton().addButton(block.getText(), url, isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case attachment: {
                        layout.addView(views.getAttachment().addAttachment(block.getText(), block.getLinkUrl(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case facebookLikeButton: {
                        layout.addView(views.getFacebookButton().addFacebookButton(block.getUrl(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case twitterFollowButton: {
                        layout.addView(views.getTwitterButton().addTwitterButton("http://twitter.com/" + block.getUsername(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    case video: {
                        VideoProvider provider = VideoProvider.valueOf("unknown");
                        try {
                            provider = VideoProvider.valueOf(block.getProvider());
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        layout.addView(views.getVideo().addVideo(block.getEmbedUrl(), provider, block.getId(), isFirstObject, isLastObject, (ViewGroup)layout));
                        continue block19;
                    }
                    default: {
                        if (block.getText() == null) continue block19;
                        layout.addView(views.getParagraph().addParagraph(block.getText(), isFirstObject, isLastObject, (ViewGroup)layout));
                    }
                }
            }
        }
        return layout;
    }

    protected Blocks(Parcel in) {
        this.inflater = (LayoutInflater)in.readValue(LayoutInflater.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue((Object)this.inflater);
    }

    private static enum Type {
        paragraph,
        heading,
        subheading,
        unorderedList,
        orderedList,
        code,
        image,
        lwr,
        button,
        facebookLikeButton,
        twitterFollowButton,
        video,
        attachment,
        unknown;

    }
}

