/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightcompressor.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import io.intercom.android.sdk.lightcompressor.video.Track;
import java.io.File;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mp4parser.support.Matrix;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bJ\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u000fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/intercom/android/sdk/lightcompressor/video/Mp4Movie;", "", "()V", "cacheFile", "Ljava/io/File;", "matrix", "Lorg/mp4parser/support/Matrix;", "kotlin.jvm.PlatformType", "tracks", "Ljava/util/ArrayList;", "Lio/intercom/android/sdk/lightcompressor/video/Track;", "Lkotlin/collections/ArrayList;", "addSample", "", "trackIndex", "", "offset", "", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "addTrack", "mediaFormat", "Landroid/media/MediaFormat;", "isAudio", "", "getCacheFile", "getMatrix", "getTracks", "setCacheFile", "file", "setRotation", "angle", "intercom-sdk-lightcompressor_release"})
public final class Mp4Movie {
    private Matrix matrix = Matrix.ROTATE_0;
    @NotNull
    private final ArrayList<Track> tracks = new ArrayList();
    @Nullable
    private File cacheFile;

    @Nullable
    public final Matrix getMatrix() {
        return this.matrix;
    }

    public final void setCacheFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.cacheFile = file;
    }

    public final void setRotation(int angle) {
        switch (angle) {
            case 0: {
                this.matrix = Matrix.ROTATE_0;
                break;
            }
            case 90: {
                this.matrix = Matrix.ROTATE_90;
                break;
            }
            case 180: {
                this.matrix = Matrix.ROTATE_180;
                break;
            }
            case 270: {
                this.matrix = Matrix.ROTATE_270;
            }
        }
    }

    @NotNull
    public final ArrayList<Track> getTracks() {
        return this.tracks;
    }

    @Nullable
    public final File getCacheFile() {
        return this.cacheFile;
    }

    public final void addSample(int trackIndex, long offset, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        if (trackIndex < 0 || trackIndex >= this.tracks.size()) {
            return;
        }
        Track track = this.tracks.get(trackIndex);
        Intrinsics.checkNotNullExpressionValue((Object)track, (String)"get(...)");
        Track track2 = track;
        track2.addSample(offset, bufferInfo);
    }

    public final int addTrack(@NotNull MediaFormat mediaFormat, boolean isAudio) {
        Intrinsics.checkNotNullParameter((Object)mediaFormat, (String)"mediaFormat");
        this.tracks.add(new Track(this.tracks.size(), mediaFormat, isAudio));
        return this.tracks.size() - 1;
    }
}

