/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fcm;

import android.content.Context;
import android.text.TextUtils;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.user.DeviceData;

public class IntercomFcmInstanceIDService
extends FirebaseInstanceIdService {
    public void onTokenRefresh() {
        String refreshedToken = FirebaseInstanceId.getInstance().getToken();
        if (TextUtils.isEmpty((CharSequence)refreshedToken)) {
            IntercomLogger.e((String)"Intercom push registration failed. Please make sure the following strings are copied from your google-services.json file to your strings.xml file: <string name=\"gcm_defaultSenderId\">YOUR_SENDER_ID</string>\n<string name=\"google_api_key\"\n>YOUR_GOOGLE_API_KEY</string>\n<string name=\"google_app_id\"\n>YOUR_GOOGLE_APP_ID</string>");
        } else {
            this.sendTokenToIntercom(refreshedToken);
        }
    }

    private void sendTokenToIntercom(String token) {
        Context context = this.getApplicationContext();
        if (!DeviceData.hasCachedPushToken((Context)context, (String)token)) {
            Injector.get().getApi().setDeviceToken(token);
            DeviceData.cachePushToken((Context)context, (String)token);
        }
    }
}

