/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.fcm;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import io.intercom.android.sdk.fcm.FcmNotificationFactory;
import io.intercom.android.sdk.fcm.PushNotification;
import java.util.ArrayList;
import java.util.List;

class FcmNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    private static final List<PushNotification> notifications = new ArrayList<PushNotification>();
    private final FcmNotificationFactory fcmNotificationFactory = new FcmNotificationFactory();
    private final NotificationManager notificationManager;

    FcmNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    void killNotifications() {
        this.notificationManager.cancel(9999997);
        notifications.clear();
    }

    List<PushNotification> getNotifications() {
        return notifications;
    }

    void createPushOnlyNotification(PushNotification notification, Context context) {
        Notification gemNotification = this.fcmNotificationFactory.createPushOnlyNotification(notification, context);
        String pushOnlyConversationId = notification.getPushOnlyConversationId();
        this.notificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), gemNotification);
    }

    void createNotification(PushNotification notification, Context context) {
        notifications.add(notification);
        Notification fcmNotification = notifications.size() == 1 ? this.fcmNotificationFactory.createSingleNotification(notifications.get(0), context) : this.fcmNotificationFactory.createGroupedNotification(notifications, context);
        this.notificationManager.notify(9999997, fcmNotification);
    }
}

