/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.gson.Gson;
import com.intercom.commons.utilities.TimeProvider;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.conversation.IntercomLinkPresenter;
import io.intercom.android.sdk.homescreen.HomeCardAdapter;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.homescreen.HomePresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.HomeCardsResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.android.sdk.views.HomeToolbar;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.decoration.HomeItemDecoration;
import java.util.ArrayList;
import java.util.List;

public class HomeFragment
extends Fragment
implements IntercomLinkPresenter.IntercomLinkHost,
HomePresenter.Listener,
Store.Subscriber2<InboxState, TeamPresence> {
    private static final int OFFSCREEN_ITEM_CACHE = 4;
    private WallpaperLoader wallpaperLoader;
    private HomeCardAdapter homeCardAdapter;
    private Store<State> store;
    private Provider<AppConfig> appConfigProvider;
    private Api api;
    private TimeProvider timeProvider;
    private Bus bus;
    private Gson gson;
    private MetricTracker metricTracker;
    private UserIdentity userIdentity;
    @Nullable
    private Store.Subscription subscription;
    private HomePresenter homePresenter;
    private HomeClickListener listener;
    private HomeToolbar toolbar;
    private View toolbarContent;
    private View closeBackground;
    private View linkContainer;
    private IntercomErrorView intercomErrorView;
    private IntercomErrorView intercomEmptyView;
    private IntercomLinkView linkView;
    private RecyclerView recyclerView;
    private List<Object> cardList = new ArrayList<Object>();
    private int statusHeight;
    private int startLocationY;
    private final BaseCallback<HomeCardsResponse.Builder> apiCallback = new BaseCallback<HomeCardsResponse.Builder>(){

        @Override
        protected void onSuccess(HomeCardsResponse.Builder builder) {
            AppConfig appConfig = (AppConfig)HomeFragment.this.appConfigProvider.get();
            HomeCardsResponse homeCardsResponse = builder.build();
            HomeFragment.this.store.dispatch(Actions.fetchHomeCardsSuccess(homeCardsResponse));
            if (!homeCardsResponse.hasConversations() && !appConfig.isInboundMessages() && homeCardsResponse.getCards().size() == 0) {
                if (HomeFragment.this.intercomEmptyView != null) {
                    HomeFragment.this.intercomEmptyView.setVisibility(0);
                }
            } else {
                HomeFragment.this.homePresenter.updateConversationCard(homeCardsResponse.hasMoreConversations());
                HomeFragment.this.homePresenter.updateCards(homeCardsResponse.getCards());
                if (HomeFragment.this.toolbar != null) {
                    HomeFragment.this.toolbar.updateContent(appConfig);
                }
            }
        }

        @Override
        protected void onError(ErrorObject errorDetails) {
            if (((AppConfig)HomeFragment.this.appConfigProvider.get()).isReceivedFromServer()) {
                HomeFragment.this.homePresenter.clearCards();
                HomeFragment.this.homePresenter.updateConversationCard(((State)HomeFragment.this.store.state()).hasConversations());
                HomeFragment.this.homePresenter.addErrorRow();
            } else {
                HomeFragment.this.homePresenter.clearCards();
                if (HomeFragment.this.intercomErrorView != null) {
                    HomeFragment.this.intercomErrorView.setVisibility(0);
                }
            }
            if (HomeFragment.this.toolbar != null) {
                HomeFragment.this.toolbar.updateContent((AppConfig)HomeFragment.this.appConfigProvider.get());
            }
        }
    };

    public static HomeFragment newInstance() {
        return new HomeFragment();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (HomeClickListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationCardClickListener");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        Injector injector = Injector.get();
        this.api = injector.getApi();
        this.appConfigProvider = injector.getAppConfigProvider();
        this.store = injector.getStore();
        this.timeProvider = injector.getTimeProvider();
        this.bus = injector.getBus();
        this.gson = injector.getGson();
        this.metricTracker = injector.getMetricTracker();
        this.userIdentity = injector.getUserIdentity();
        View rootView = inflater.inflate(R.layout.intercom_fragment_home, container, false);
        this.statusHeight = WindowUtils.getStatusBarHeight(this.getResources());
        this.toolbar = (HomeToolbar)rootView.findViewById(R.id.intercom_toolbar);
        this.toolbarContent = rootView.findViewById(R.id.toolbar_content_container);
        this.recyclerView = (RecyclerView)rootView.findViewById(R.id.card_list);
        this.closeBackground = rootView.findViewById(R.id.intercom_close_background);
        this.intercomErrorView = (IntercomErrorView)rootView.findViewById(R.id.error_layout_home_screen);
        this.intercomEmptyView = (IntercomErrorView)rootView.findViewById(R.id.error_layout_empty_screen);
        this.setUpErrorScreen();
        this.setUpEmptyScreen();
        this.setUpToolbar(this.appConfigProvider);
        this.setUpScrollListener();
        this.setUpCloseButton(this.appConfigProvider.get(), rootView.findViewById(R.id.intercom_home_close_container));
        this.setUpLinkView(this.appConfigProvider, this.api, rootView, injector.getAppIdentity().appId(), this.userIdentity.getIntercomId());
        this.setUpCardList(this.appConfigProvider, this.store, this.timeProvider, this.bus, this.gson, this.metricTracker, this.userIdentity);
        return rootView;
    }

    public void onStart() {
        super.onStart();
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, Selectors.TEAM_PRESENCE, this);
    }

    public void onResume() {
        this.store.dispatch(Actions.homeOpened());
        super.onResume();
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onStop();
    }

    public void onDestroyView() {
        this.toolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroyView();
    }

    private void setUpScrollListener() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.recyclerView.setOnScrollChangeListener(new View.OnScrollChangeListener(){

                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                    HomeFragment.this.homePresenter.renderHeaderScrollChange(HomeFragment.this.recyclerView, HomeFragment.this.startLocationY, HomeFragment.this.closeBackground, HomeFragment.this.toolbarContent);
                }
            });
        } else {
            this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    HomeFragment.this.homePresenter.renderHeaderScrollChange(recyclerView, HomeFragment.this.startLocationY, HomeFragment.this.closeBackground, HomeFragment.this.toolbarContent);
                }
            });
        }
    }

    private void setUpErrorScreen() {
        this.intercomErrorView.setActionButtonTextColor(ColorUtils.primaryOrDarkColor(this.intercomErrorView.getContext(), this.appConfigProvider.get()));
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.intercomErrorView.setVisibility(8);
                HomeFragment.this.loadHomeScreen();
            }
        });
    }

    private void setUpEmptyScreen() {
        TextView closeButton = (TextView)this.intercomEmptyView.findViewById(R.id.close_button);
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.intercomEmptyView.setVisibility(8);
                HomeFragment.this.listener.onCloseClicked();
            }
        });
        this.applyCloseButtonStyle(closeButton, this.appConfigProvider.get());
    }

    private void applyCloseButtonStyle(TextView closeButton, AppConfig appConfig) {
        Context context = closeButton.getContext();
        int primaryColor = ColorUtils.primaryOrDarkColor(context, appConfig);
        FontUtils.setRobotoMediumTypeface(closeButton);
        Drawable drawable2 = closeButton.getBackground();
        BackgroundUtils.setRippleButtonStroke(context, drawable2, R.id.background, primaryColor);
        closeButton.setTextColor(primaryColor);
    }

    private void setUpCloseButton(AppConfig appConfig, View close) {
        ColorUtils.setImageColorWhiteOrBlack((ImageView)close.findViewById(R.id.intercom_toolbar_close), appConfig.secondaryColorRenderDarkText());
        close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.listener.onCloseClicked();
            }
        });
        close.setPadding(close.getPaddingLeft(), close.getPaddingTop() + this.statusHeight, close.getPaddingRight(), close.getPaddingBottom());
        ViewGroup.LayoutParams params = close.getLayoutParams();
        params.height += this.statusHeight;
        close.setLayoutParams(params);
    }

    private void setUpCardList(Provider<AppConfig> appConfigProvider, Store<State> store, TimeProvider timeProvider, Bus bus, Gson gson, MetricTracker metricTracker, UserIdentity userIdentity) {
        this.homePresenter = new HomePresenter(store, appConfigProvider, this.cardList, this);
        TimeFormatter timeFormatter = new TimeFormatter(this.getContext(), timeProvider);
        this.homeCardAdapter = new HomeCardAdapter(this.cardList, store, appConfigProvider, bus, gson, metricTracker, timeFormatter, this.listener, userIdentity, (Activity)this.getActivity());
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.homeCardAdapter);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new HomeItemDecoration(this.getContext(), this.cardList));
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recyclerView.setItemViewCacheSize(4);
        this.recyclerView.setItemAnimator(null);
        this.loadHomeScreen();
    }

    private void setUpLinkView(Provider<AppConfig> appConfigProvider, Api api, View rootView, String appId, String userId) {
        this.linkView = (IntercomLinkView)rootView.findViewById(R.id.intercom_link);
        this.linkContainer = rootView.findViewById(R.id.intercom_home_link_container);
        IntercomLinkPresenter linkPresenter = new IntercomLinkPresenter(this.linkView, appConfigProvider, api, "", appId, userId, true);
        linkPresenter.setup(this);
        if (appConfigProvider.get().shouldShowIntercomLink()) {
            this.linkContainer.setVisibility(0);
            this.recyclerView.setPadding(this.recyclerView.getPaddingLeft(), this.recyclerView.getPaddingTop(), this.recyclerView.getPaddingRight(), this.recyclerView.getPaddingBottom() + this.getResources().getDimensionPixelSize(R.dimen.intercom_link_height));
        } else {
            this.linkContainer.setVisibility(8);
        }
    }

    private void setUpToolbar(Provider<AppConfig> appConfigProvider) {
        int backgroundColor = appConfigProvider.get().getSecondaryColor();
        this.toolbar.setBackgroundColor(backgroundColor);
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), appConfigProvider);
        this.toolbar.loadWallpaper(this.wallpaperLoader);
        this.toolbar.setBackgroundColor(backgroundColor);
        this.toolbar.updateToolbarColors(appConfigProvider.get());
        this.toolbarContent.setPadding(this.toolbarContent.getPaddingLeft(), this.toolbarContent.getPaddingTop() + this.statusHeight, this.toolbarContent.getPaddingRight(), this.toolbarContent.getPaddingBottom());
        this.toolbar.updateContent(appConfigProvider.get());
        this.animateHeaderIn();
        this.updateRecyclerViewPosition();
    }

    private void animateHeaderIn() {
        this.toolbar.animateIn(this.toolbarContent);
    }

    private void updateRecyclerViewPosition() {
        this.startLocationY = this.recyclerView.getPaddingTop() + this.toolbar.getContentHeight(this.toolbarContent) - this.getResources().getDimensionPixelSize(R.dimen.intercom_home_screen_overlap);
        this.recyclerView.setPadding(this.recyclerView.getPaddingLeft(), this.startLocationY, this.recyclerView.getPaddingRight(), this.recyclerView.getPaddingBottom());
    }

    private void loadHomeScreen() {
        this.homePresenter.clearCards();
        this.homePresenter.addLoadingCards();
        this.api.fetchHomeCards(this.apiCallback);
    }

    @Override
    public void addBottomPadding(int extraBottomPadding) {
    }

    @Override
    public boolean isAtBottom() {
        return false;
    }

    @Override
    public void notifyItemChanged(int position) {
        this.homeCardAdapter.notifyItemChanged(position);
    }

    @Override
    public void onStateChange(InboxState inboxState, TeamPresence teamPresence) {
        if (inboxState.status().equals((Object)InboxState.Status.SUCCESS) && !teamPresence.isEmpty()) {
            this.homePresenter.updateConversationCard();
        }
    }

    public void reload() {
        this.loadHomeScreen();
    }
}

