/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.content.res.AssetManager;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.data.FileDescriptorAssetPathFetcher;
import io.intercom.com.bumptech.glide.load.data.StreamAssetPathFetcher;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import java.io.InputStream;

public class AssetUriLoader<Data>
implements ModelLoader<Uri, Data> {
    private static final String ASSET_PATH_SEGMENT = "android_asset";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    private final AssetManager assetManager;
    private final AssetFetcherFactory<Data> factory;

    public AssetUriLoader(AssetManager assetManager, AssetFetcherFactory<Data> factory) {
        this.assetManager = assetManager;
        this.factory = factory;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(Uri model, int width, int height, Options options) {
        String assetPath = model.toString().substring(ASSET_PREFIX_LENGTH);
        return new ModelLoader.LoadData<Data>(new ObjectKey(model), this.factory.buildFetcher(this.assetManager, assetPath));
    }

    @Override
    public boolean handles(Uri model) {
        return "file".equals(model.getScheme()) && !model.getPathSegments().isEmpty() && ASSET_PATH_SEGMENT.equals(model.getPathSegments().get(0));
    }

    public static class FileDescriptorFactory
    implements ModelLoaderFactory<Uri, ParcelFileDescriptor>,
    AssetFetcherFactory<ParcelFileDescriptor> {
        private final AssetManager assetManager;

        public FileDescriptorFactory(AssetManager assetManager) {
            this.assetManager = assetManager;
        }

        @Override
        public ModelLoader<Uri, ParcelFileDescriptor> build(MultiModelLoaderFactory multiFactory) {
            return new AssetUriLoader<ParcelFileDescriptor>(this.assetManager, this);
        }

        @Override
        public void teardown() {
        }

        @Override
        public DataFetcher<ParcelFileDescriptor> buildFetcher(AssetManager assetManager, String assetPath) {
            return new FileDescriptorAssetPathFetcher(assetManager, assetPath);
        }
    }

    public static class StreamFactory
    implements ModelLoaderFactory<Uri, InputStream>,
    AssetFetcherFactory<InputStream> {
        private final AssetManager assetManager;

        public StreamFactory(AssetManager assetManager) {
            this.assetManager = assetManager;
        }

        @Override
        public ModelLoader<Uri, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new AssetUriLoader<InputStream>(this.assetManager, this);
        }

        @Override
        public void teardown() {
        }

        @Override
        public DataFetcher<InputStream> buildFetcher(AssetManager assetManager, String assetPath) {
            return new StreamAssetPathFetcher(assetManager, assetPath);
        }
    }

    public static interface AssetFetcherFactory<Data> {
        public DataFetcher<Data> buildFetcher(AssetManager var1, String var2);
    }
}

