/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.ImageClickListener;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.ImageBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.transforms.GreyscaleTransform;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.IntercomShimmerLayout;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.com.bumptech.glide.RequestBuilder;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.facebook.shimmer.ShimmerFrameLayout;

public class NetworkImage
extends Image
implements ImageBlock {
    private final UploadingImageCache uploadingImageCache;
    @Nullable
    private final ImageClickListener listener;
    private final RequestManager requestManager;
    private final Twig twig = LumberMill.getLogger();

    NetworkImage(StyleType style2, UploadingImageCache uploadingImageCache, @Nullable ImageClickListener listener, RequestManager requestManager) {
        super(style2);
        this.uploadingImageCache = uploadingImageCache;
        this.listener = listener;
        this.requestManager = requestManager;
    }

    @Override
    public View addImage(String url, String linkUrl, int width, int height, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        int widthPx = ScreenUtils.dpToPx((float)width, (Context)context);
        int heightPx = ScreenUtils.dpToPx((float)height, (Context)context);
        IntercomShimmerLayout rootView = new IntercomShimmerLayout(context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        ResizableImageView imageView = new ResizableImageView(context);
        imageView.setTransitionName("lightbox_image");
        imageView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        this.setBackground((ImageView)imageView);
        rootView.addView((View)imageView);
        this.loadImageFromUrl(url, linkUrl, context, widthPx, heightPx, imageView, rootView);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), blockMetadata.isLastObject());
        return rootView;
    }

    private void loadImageFromUrl(final String url, final String linkUrl, final Context context, final int widthPx, final int heightPx, final ResizableImageView imageView, final ShimmerFrameLayout shimmerView) {
        Uri localImageUri;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.hideLoadingState(shimmerView, (ImageView)imageView);
            imageView.setImageResource(R.drawable.intercom_image_load_failed);
            imageView.setScaleType(ImageView.ScaleType.CENTER);
            return;
        }
        RequestBuilder requestCreator = this.requestManager.load(url);
        this.setImageViewBounds(widthPx, heightPx, imageView, requestCreator);
        Resources resources = context.getResources();
        RequestOptions requestOptions = new RequestOptions().error(R.drawable.intercom_image_load_failed).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url)).skipMemoryCache(false);
        if (this.getStyle() != StyleType.CAROUSEL) {
            requestOptions = requestOptions.transform((Transformation)new RoundedCornersTransform(resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners)));
        }
        if ((localImageUri = this.uploadingImageCache.getLocalImageUriForRemoteUrl(url)) != null) {
            requestCreator = requestCreator.thumbnail(this.requestManager.load(localImageUri).apply(new RequestOptions().transform((Transformation)new GreyscaleTransform())));
        }
        requestCreator.apply(requestOptions).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                imageView.setScaleType(ImageView.ScaleType.CENTER);
                NetworkImage.this.hideLoadingState(shimmerView, (ImageView)imageView);
                NetworkImage.this.twig.internal("images", "FAILURE");
                imageView.setScaleType(ImageView.ScaleType.CENTER);
                return false;
            }

            public boolean onResourceReady(Drawable drawable2, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                NetworkImage.this.twig.internal("images", "SUCCESS");
                NetworkImage.this.hideLoadingState(shimmerView, (ImageView)imageView);
                if (NetworkImage.this.getStyle() != StyleType.CHAT_FULL && NetworkImage.this.listener != null) {
                    imageView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                            NetworkImage.this.listener.onImageClicked(url, linkUrl, (ImageView)imageView, widthPx, heightPx);
                        }
                    });
                }
                return false;
            }
        }).into((ImageView)imageView);
    }

    @VisibleForTesting
    int getSampleSize(int scaledWidth, int scaledHeight, DisplayMetrics displayMetrics) {
        int sampleSize = 1;
        if (scaledWidth > displayMetrics.widthPixels || scaledHeight > displayMetrics.heightPixels) {
            sampleSize = (int)Math.pow(2.0, (int)Math.ceil(Math.log((double)displayMetrics.widthPixels / (double)Math.max(scaledHeight, scaledWidth)) / Math.log(0.5)));
        }
        return sampleSize;
    }

    void hideLoadingState(ShimmerFrameLayout shimmerView, ImageView imageView) {
        if (shimmerView != null) {
            shimmerView.hideShimmer();
            imageView.setBackgroundResource(17170445);
        }
    }
}

