/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.articles;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.articles.ArticleWebViewClient;
import io.intercom.android.sdk.articles.ArticleWebViewListener;
import io.intercom.android.sdk.articles.ArticleWebViewPresenter;
import io.intercom.android.sdk.articles.ArticleWebViewView;
import io.intercom.android.sdk.helpcenter.HelpCenterWebViewInterface;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.views.IntercomShimmerLayout;
import io.intercom.com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;

public class IntercomArticleWebViewActivity
extends AppCompatActivity
implements ArticleWebViewView,
ArticleWebViewListener {
    public static final String ARTICLE_ID = "articleID";
    private WebView webView;
    private IntercomShimmerLayout shimmerLayout;
    private TextView errorText;
    private UserIdentity userIdentity;
    private AppIdentity appIdentity;
    Provider<AppConfig> appConfigProvider;
    private Gson gson;
    private MetricTracker metricTracker;
    private Provider<Api> apiProvider;
    private static final Twig twig = LumberMill.getLogger();
    private TextView retryButton;
    private ArticleWebViewPresenter articleWebViewPresenter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_article_web_view);
        this.addShimmerLayout();
        this.retryButton = (TextView)this.findViewById(R.id.intercom_article_retry);
        this.webView = (WebView)this.findViewById(R.id.intercom_webview_article);
        this.errorText = (TextView)this.findViewById(R.id.intercom_article_error);
        Bundle data = this.getIntent().getExtras();
        Injector injector = Injector.get();
        this.metricTracker = injector.getMetricTracker();
        this.apiProvider = injector.getApiProvider();
        this.appConfigProvider = injector.getAppConfigProvider();
        this.gson = injector.getGson();
        this.userIdentity = injector.getUserIdentity();
        this.appIdentity = injector.getAppIdentity();
        View closeButton = this.findViewById(R.id.intercom_article_close);
        closeButton.setOnClickListener(view -> this.finish());
        if (data != null) {
            String baseUrl = this.appConfigProvider.get().getHelpCenterUrl();
            boolean isUserRegistered = this.userIdentity.identityExists();
            String articleId = data.getString(ARTICLE_ID, "");
            this.articleWebViewPresenter = new ArticleWebViewPresenter(this, baseUrl, articleId, isUserRegistered);
            this.articleWebViewPresenter.onUiLoad();
        }
    }

    private void addShimmerLayout() {
        IntercomShimmerLayout intercomShimmerLayout;
        this.shimmerLayout = intercomShimmerLayout = new IntercomShimmerLayout((Context)this);
        ConstraintLayout root = (ConstraintLayout)this.findViewById(R.id.intercom_article_webview_root);
        int shimmerLayoutID = View.generateViewId();
        intercomShimmerLayout.setId(shimmerLayoutID);
        View view = this.getLayoutInflater().inflate(R.layout.intercom_article_webview_placeholder, (ViewGroup)root, false);
        ConstraintLayout.LayoutParams layoutParams = new ConstraintLayout.LayoutParams(-1, 0);
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.connect(shimmerLayoutID, 6, root.getId(), 6);
        constraintSet.connect(shimmerLayoutID, 7, root.getId(), 7);
        constraintSet.connect(shimmerLayoutID, 4, root.getId(), 4);
        constraintSet.connect(shimmerLayoutID, 3, R.id.intercom_article_close, 4);
        intercomShimmerLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        intercomShimmerLayout.addView(view);
        root.addView((View)intercomShimmerLayout);
        constraintSet.applyTo(root);
    }

    public static Intent buildIntent(@NonNull Context context, @NonNull String articleId) {
        Intent intent = new Intent(context, IntercomArticleWebViewActivity.class);
        intent.putExtra(ARTICLE_ID, articleId);
        intent.setFlags(0x10000000);
        return intent;
    }

    @Override
    public void showLoadingState() {
        this.errorText.setVisibility(8);
        this.retryButton.setVisibility(8);
        this.webView.setVisibility(8);
        this.shimmerLayout.setVisibility(0);
        this.shimmerLayout.startShimmer();
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void loadUrl(String url) {
        this.webView.setWebViewClient((WebViewClient)new ArticleWebViewClient(url, this));
        this.webView.getSettings().setJavaScriptEnabled(true);
        HelpCenterWebViewInterface helpCenterWebViewInterface = new HelpCenterWebViewInterface(this.webView, this.gson, this.metricTracker, this.apiProvider.get(), "from_article_on_button");
        this.webView.addJavascriptInterface((Object)helpCenterWebViewInterface, "AndroidHost");
        this.webView.loadUrl(url, this.createHeaders());
    }

    private Map<String, String> createHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("MobileClientDisplayType", "AndroidIntercomHeaderless");
        headers.put("MobileClient", "AndroidIntercomWebView");
        return headers;
    }

    @Override
    public void setCookies(String baseUrl) {
        String key = "intercom-session-" + this.appIdentity.appId();
        String value = this.userIdentity.getEncryptedUserId();
        CookieManager.getInstance().setCookie(baseUrl, key + "=" + value);
    }

    @Override
    public void showContent() {
        this.webView.setVisibility(0);
        this.errorText.setVisibility(8);
        this.retryButton.setVisibility(8);
        this.shimmerLayout.setVisibility(8);
        this.shimmerLayout.stopShimmer();
    }

    @Override
    public void showError() {
        this.webView.setVisibility(8);
        this.errorText.setText(R.string.intercom_something_went_wrong_try_again);
        this.errorText.setVisibility(0);
        this.retryButton.setVisibility(0);
        this.buildRetryButton();
        this.shimmerLayout.stopShimmer();
        this.shimmerLayout.setVisibility(8);
    }

    private void buildRetryButton() {
        FontUtils.setRobotoMediumTypeface(this.retryButton);
        BackgroundUtils.setButtonColor(this.retryButton, this.appConfigProvider.get().getPrimaryColor());
        this.retryButton.setOnClickListener(view -> this.articleWebViewPresenter.onUiLoad());
    }

    @Override
    public void logUserNotRegisteredError() {
        twig.e("User should be registered before loading articles.", new Object[0]);
    }

    @Override
    public void showArticleNotFoundError() {
        this.webView.setVisibility(8);
        this.errorText.setText(R.string.intercom_page_not_found);
        this.errorText.setVisibility(0);
        this.retryButton.setVisibility(8);
        this.shimmerLayout.stopShimmer();
        this.shimmerLayout.setVisibility(8);
    }

    @Override
    public void onArticleStartedLoading() {
        this.articleWebViewPresenter.onWebViewStartedLoading();
    }

    @Override
    public void onArticleFinishedLoading() {
        this.articleWebViewPresenter.onWebViewFinishedLoading();
    }

    @Override
    public void onArticleLoadingError() {
        this.articleWebViewPresenter.onWebViewError();
    }

    @Override
    public void articleNotFound() {
        this.articleWebViewPresenter.articleNotFound();
    }
}

