/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusEventPropagator;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusSocket;
import io.intercom.android.sdk.nexus.NexusTopicProvider;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.okhttp3.OkHttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NexusClient
implements NexusTopicProvider {
    private final List<NexusSocket> sockets = new ArrayList<NexusSocket>();
    private final List<String> topics = new ArrayList<String>();
    private final Twig twig;
    private final OkHttpClient client;
    private final NexusEventPropagator eventPropagator;
    @Nullable
    private ScheduledExecutorService backgroundTaskExecutor;
    private ScheduledFuture future;
    private long presenceInterval;

    public static OkHttpClient.Builder defaultOkHttpClientBuilder() {
        return new OkHttpClient.Builder().readTimeout(130L, TimeUnit.SECONDS).writeTimeout(130L, TimeUnit.SECONDS).connectTimeout(20L, TimeUnit.SECONDS);
    }

    public NexusClient(Twig twig) {
        this(twig, NexusClient.defaultOkHttpClientBuilder().build());
    }

    public NexusClient(Twig twig, OkHttpClient okHttpClient) {
        this(twig, okHttpClient, new NexusEventPropagator(twig));
    }

    NexusClient(Twig twig, OkHttpClient client, NexusEventPropagator eventPropagator) {
        this.twig = twig;
        this.eventPropagator = eventPropagator;
        this.client = client;
    }

    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (config.getEndpoints().isEmpty()) {
            this.twig.e("No endpoints present", new Object[0]);
            return;
        }
        if (this.backgroundTaskExecutor == null) {
            NexusThreadFactory threadFactory = new NexusThreadFactory();
            this.backgroundTaskExecutor = Executors.newScheduledThreadPool(config.getEndpoints().size() + 1, threadFactory);
        }
        for (String url : config.getEndpoints()) {
            this.twig.i("Adding socket", new Object[0]);
            NexusSocket socket = new NexusSocket(url, config.getConnectionTimeout(), shouldSendPresence, this.twig, this.backgroundTaskExecutor, this.client, this.eventPropagator, this);
            socket.connect();
            this.sockets.add(socket);
        }
        this.presenceInterval = config.getPresenceHeartbeatInterval();
        if (shouldSendPresence) {
            this.schedulePresence();
        }
    }

    public synchronized void disconnect() {
        if (!this.sockets.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                this.twig.i("disconnecting socket", new Object[0]);
                nexusSocket.disconnect();
            }
            this.sockets.clear();
            this.twig.i("client disconnected", new Object[0]);
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public synchronized void fire(NexusEvent event) {
        this.eventPropagator.cacheEvent(event);
        String data = event.toStringEncodedJsonObject();
        if (!data.isEmpty()) {
            for (NexusSocket nexusSocket : this.sockets) {
                nexusSocket.fire(data);
            }
        }
    }

    public synchronized void localUpdate(@NonNull NexusEvent event) {
        this.eventPropagator.notifyEvent(event);
    }

    public synchronized boolean isConnected() {
        for (NexusSocket socket : this.sockets) {
            if (!socket.isConnected()) continue;
            return true;
        }
        return false;
    }

    public void addEventListener(@NonNull NexusListener listener) {
        this.eventPropagator.addListener(listener);
    }

    public void removeEventListener(@NonNull NexusListener listener) {
        this.eventPropagator.removeListener(listener);
    }

    @Override
    @NonNull
    public synchronized List<String> getTopics() {
        return this.topics;
    }

    public synchronized void setTopics(@NonNull List<String> newTopics) {
        ArrayList<String> topicsToSubscribe = new ArrayList<String>(newTopics);
        topicsToSubscribe.removeAll(this.topics);
        ArrayList<String> topicsToUnsubscribe = new ArrayList<String>(this.topics);
        topicsToUnsubscribe.removeAll(newTopics);
        this.subscribeToTopics(topicsToSubscribe);
        this.unSubscribeFromTopics(topicsToUnsubscribe);
        this.topics.clear();
        this.topics.addAll(newTopics);
    }

    public synchronized void addTopics(@NonNull List<String> newTopics) {
        ArrayList<String> topicsToSubscribe = new ArrayList<String>(newTopics);
        topicsToSubscribe.removeAll(this.topics);
        this.subscribeToTopics(topicsToSubscribe);
        this.topics.addAll(topicsToSubscribe);
    }

    public synchronized void removeTopics(@NonNull List<String> topicsToRemove) {
        ArrayList<String> topicsToUnsubscribe = new ArrayList<String>();
        for (String topic : topicsToRemove) {
            if (!this.topics.contains(topic)) continue;
            topicsToUnsubscribe.add(topic);
        }
        this.unSubscribeFromTopics(topicsToUnsubscribe);
        this.topics.removeAll(topicsToUnsubscribe);
    }

    public synchronized void clearTopics() {
        this.unSubscribeFromTopics(this.topics);
        this.topics.clear();
    }

    private void subscribeToTopics(@NonNull List<String> topics) {
        if (!topics.isEmpty()) {
            this.fire(NexusEvent.getSubscribeEvent(topics));
        }
    }

    private void unSubscribeFromTopics(@NonNull List<String> topics) {
        if (!topics.isEmpty()) {
            this.fire(NexusEvent.getUnsubscribeEvent(topics));
        }
    }

    private void schedulePresence() {
        if (this.presenceInterval > 0L) {
            this.future = this.backgroundTaskExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    NexusClient.this.fire(NexusEvent.getUserPresenceEvent());
                    NexusClient.this.schedulePresence();
                }
            }, this.presenceInterval, TimeUnit.SECONDS);
        }
    }

    private static class NexusThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private int threadCount = 0;

        private NexusThreadFactory() {
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            ++this.threadCount;
            thread.setName("IntercomNexus-" + this.threadCount);
            return thread;
        }
    }
}

