/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.content.res.Resources;
import android.media.SoundPool;
import androidx.annotation.RawRes;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;

public class SoundPlayer {
    private static final Twig TWIG = LumberMill.getLogger();
    @VisibleForTesting
    static final int NOT_FOUND_ID = -1;
    private final SoundPool soundPool;
    private final Provider<AppConfig> appConfigProvider;
    final int messageReceivedId;
    final int replyFailedId;
    final int replySentId;
    private final int operatorReceivedId;
    boolean messageReceivedLoaded;
    boolean replyFailedLoaded;
    boolean replySentLoaded;
    private boolean operatorReceivedLoaded;

    public SoundPlayer(Context context, Provider<AppConfig> appConfigProvider) {
        this(context, appConfigProvider, new SoundPool(1, 5, 0));
    }

    @VisibleForTesting
    SoundPlayer(Context context, Provider<AppConfig> appConfigProvider, SoundPool soundPool) {
        this.appConfigProvider = appConfigProvider;
        this.soundPool = soundPool;
        this.soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (status == 0) {
                    if (sampleId == SoundPlayer.this.messageReceivedId) {
                        SoundPlayer.this.messageReceivedLoaded = true;
                    } else if (sampleId == SoundPlayer.this.replyFailedId) {
                        SoundPlayer.this.replyFailedLoaded = true;
                    } else if (sampleId == SoundPlayer.this.replySentId) {
                        SoundPlayer.this.replySentLoaded = true;
                    } else if (sampleId == SoundPlayer.this.operatorReceivedId) {
                        SoundPlayer.this.operatorReceivedLoaded = true;
                    }
                }
            }
        });
        this.messageReceivedId = this.loadSound(context, R.raw.intercom_received);
        this.replyFailedId = this.loadSound(context, R.raw.intercom_failed);
        this.replySentId = this.loadSound(context, R.raw.intercom_sent);
        this.operatorReceivedId = this.loadSound(context, R.raw.intercom_operator);
    }

    private int loadSound(Context context, @RawRes int soundId) {
        try {
            return this.soundPool.load(context, soundId, 1);
        }
        catch (Resources.NotFoundException e) {
            TWIG.e((Throwable)e, "Could not play sound", new Object[0]);
            return -1;
        }
    }

    public void playReplyFailedSound() {
        this.playIfLoaded(this.replyFailedLoaded, this.replyFailedId);
    }

    public void playReplySentSound() {
        this.playIfLoaded(this.replySentLoaded, this.replySentId);
    }

    public void playMessageReceivedSound() {
        this.playIfLoaded(this.messageReceivedLoaded, this.messageReceivedId);
    }

    public void playOperatorReceivedSound() {
        this.playIfLoaded(this.operatorReceivedLoaded, this.operatorReceivedId);
    }

    @VisibleForTesting
    void playIfLoaded(boolean loaded, int soundId) {
        if (loaded && soundId != -1 && this.appConfigProvider.get().isAudioEnabled()) {
            this.soundPool.play(soundId, 1.0f, 1.0f, 1, 0, 1.0f);
        }
    }
}

