/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.Registry;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoader;
import io.intercom.com.bumptech.glide.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MultiModelLoaderFactory {
    private static final Factory DEFAULT_FACTORY = new Factory();
    private static final ModelLoader<Object, Object> EMPTY_MODEL_LOADER = new EmptyModelLoader();
    private final List<Entry<?, ?>> entries = new ArrayList();
    private final Factory factory;
    private final Set<Entry<?, ?>> alreadyUsedEntries = new HashSet();
    private final Pools.Pool<List<Throwable>> throwableListPool;

    public MultiModelLoaderFactory(Pools.Pool<List<Throwable>> throwableListPool) {
        this(throwableListPool, DEFAULT_FACTORY);
    }

    @VisibleForTesting
    MultiModelLoaderFactory(Pools.Pool<List<Throwable>> throwableListPool, Factory factory2) {
        this.throwableListPool = throwableListPool;
        this.factory = factory2;
    }

    synchronized <Model, Data> void append(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
        this.add(modelClass, dataClass, factory2, true);
    }

    synchronized <Model, Data> void prepend(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
        this.add(modelClass, dataClass, factory2, false);
    }

    private <Model, Data> void add(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2, boolean append) {
        Entry<? extends Model, ? extends Data> entry = new Entry<Model, Data>(modelClass, dataClass, factory2);
        this.entries.add(append ? this.entries.size() : 0, entry);
    }

    synchronized <Model, Data> List<ModelLoaderFactory<? extends Model, ? extends Data>> replace(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
        List<ModelLoaderFactory<? extends Model, ? extends Data>> removed = this.remove(modelClass, dataClass);
        this.append(modelClass, dataClass, factory2);
        return removed;
    }

    synchronized <Model, Data> List<ModelLoaderFactory<? extends Model, ? extends Data>> remove(Class<Model> modelClass, Class<Data> dataClass) {
        ArrayList<ModelLoaderFactory<Model, Data>> factories = new ArrayList<ModelLoaderFactory<Model, Data>>();
        Iterator<Entry<?, ?>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry<Model, Model> entry = iterator.next();
            if (!entry.handles(modelClass, dataClass)) continue;
            iterator.remove();
            factories.add(this.getFactory(entry));
        }
        return factories;
    }

    synchronized <Model> List<ModelLoader<Model, ?>> build(Class<Model> modelClass) {
        try {
            ArrayList loaders = new ArrayList();
            for (Entry<Model, Model> entry : this.entries) {
                if (this.alreadyUsedEntries.contains(entry) || !entry.handles(modelClass)) continue;
                this.alreadyUsedEntries.add(entry);
                loaders.add(this.build(entry));
                this.alreadyUsedEntries.remove(entry);
            }
            return loaders;
        }
        catch (Throwable t) {
            this.alreadyUsedEntries.clear();
            throw t;
        }
    }

    synchronized List<Class<?>> getDataClasses(Class<?> modelClass) {
        ArrayList result = new ArrayList();
        for (Entry<?, ?> entry : this.entries) {
            if (result.contains(entry.dataClass) || !entry.handles(modelClass)) continue;
            result.add(entry.dataClass);
        }
        return result;
    }

    public synchronized <Model, Data> ModelLoader<Model, Data> build(Class<Model> modelClass, Class<Data> dataClass) {
        try {
            ArrayList loaders = new ArrayList();
            boolean ignoredAnyEntries = false;
            for (Entry<Model, Model> entry : this.entries) {
                if (this.alreadyUsedEntries.contains(entry)) {
                    ignoredAnyEntries = true;
                    continue;
                }
                if (!entry.handles(modelClass, dataClass)) continue;
                this.alreadyUsedEntries.add(entry);
                loaders.add(this.build(entry));
                this.alreadyUsedEntries.remove(entry);
            }
            if (loaders.size() > 1) {
                return this.factory.build(loaders, this.throwableListPool);
            }
            if (loaders.size() == 1) {
                return (ModelLoader)loaders.get(0);
            }
            if (ignoredAnyEntries) {
                return MultiModelLoaderFactory.emptyModelLoader();
            }
            throw new Registry.NoModelLoaderAvailableException(modelClass, dataClass);
        }
        catch (Throwable t) {
            this.alreadyUsedEntries.clear();
            throw t;
        }
    }

    private <Model, Data> ModelLoaderFactory<Model, Data> getFactory(Entry<?, ?> entry) {
        return entry.factory;
    }

    private <Model, Data> ModelLoader<Model, Data> build(Entry<?, ?> entry) {
        return Preconditions.checkNotNull(entry.factory.build(this));
    }

    private static <Model, Data> ModelLoader<Model, Data> emptyModelLoader() {
        return EMPTY_MODEL_LOADER;
    }

    private static class EmptyModelLoader
    implements ModelLoader<Object, Object> {
        EmptyModelLoader() {
        }

        @Override
        @Nullable
        public ModelLoader.LoadData<Object> buildLoadData(Object o, int width, int height, Options options) {
            return null;
        }

        @Override
        public boolean handles(Object o) {
            return false;
        }
    }

    static class Factory {
        Factory() {
        }

        public <Model, Data> MultiModelLoader<Model, Data> build(List<ModelLoader<Model, Data>> modelLoaders, Pools.Pool<List<Throwable>> throwableListPool) {
            return new MultiModelLoader<Model, Data>(modelLoaders, throwableListPool);
        }
    }

    private static class Entry<Model, Data> {
        private final Class<Model> modelClass;
        final Class<Data> dataClass;
        final ModelLoaderFactory<? extends Model, ? extends Data> factory;

        public Entry(Class<Model> modelClass, Class<Data> dataClass, ModelLoaderFactory<? extends Model, ? extends Data> factory2) {
            this.modelClass = modelClass;
            this.dataClass = dataClass;
            this.factory = factory2;
        }

        public boolean handles(Class<?> modelClass, Class<?> dataClass) {
            return this.handles(modelClass) && this.dataClass.isAssignableFrom(dataClass);
        }

        public boolean handles(Class<?> modelClass) {
            return this.modelClass.isAssignableFrom(modelClass);
        }
    }
}

