/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.drawable;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableDecoderCompat;
import io.intercom.com.bumptech.glide.load.resource.drawable.NonOwnedDrawableResource;
import java.io.IOException;
import java.util.List;

public class ResourceDrawableDecoder
implements ResourceDecoder<Uri, Drawable> {
    private static final int NAME_URI_PATH_SEGMENTS = 2;
    private static final int TYPE_PATH_SEGMENT_INDEX = 0;
    private static final int NAME_PATH_SEGMENT_INDEX = 1;
    private static final int ID_PATH_SEGMENTS = 1;
    private static final int RESOURCE_ID_SEGMENT_INDEX = 0;
    private final Context context;

    public ResourceDrawableDecoder(Context context) {
        this.context = context.getApplicationContext();
    }

    @Override
    public boolean handles(Uri source2, Options options) throws IOException {
        return source2.getScheme().equals("android.resource");
    }

    @Override
    @NonNull
    public Resource<Drawable> decode(Uri source2, int width, int height, Options options) throws IOException {
        int resId = this.loadResourceIdFromUri(source2);
        String packageName = source2.getAuthority();
        Context toUse = packageName.equals(this.context.getPackageName()) ? this.context : this.getContextForPackage(source2, packageName);
        Drawable drawable = DrawableDecoderCompat.getDrawable(toUse, resId);
        return NonOwnedDrawableResource.newInstance(drawable);
    }

    @NonNull
    private Context getContextForPackage(Uri source2, String packageName) {
        try {
            return this.context.createPackageContext(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("Failed to obtain context or unrecognized Uri format for: " + source2, e);
        }
    }

    @DrawableRes
    private int loadResourceIdFromUri(Uri source2) {
        List segments = source2.getPathSegments();
        Integer result = null;
        if (segments.size() == 2) {
            String packageName = source2.getAuthority();
            String typeName = (String)segments.get(0);
            String resourceName = (String)segments.get(1);
            result = this.context.getResources().getIdentifier(resourceName, typeName, packageName);
        } else if (segments.size() == 1) {
            try {
                result = Integer.valueOf((String)segments.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unrecognized Uri format: " + source2);
        }
        if (result == 0) {
            throw new IllegalArgumentException("Failed to obtain resource id for: " + source2);
        }
        return result;
    }
}

