/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.manager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.view.View;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.manager.ApplicationLifecycle;
import io.intercom.com.bumptech.glide.manager.EmptyRequestManagerTreeNode;
import io.intercom.com.bumptech.glide.manager.Lifecycle;
import io.intercom.com.bumptech.glide.manager.RequestManagerFragment;
import io.intercom.com.bumptech.glide.manager.RequestManagerTreeNode;
import io.intercom.com.bumptech.glide.manager.SupportRequestManagerFragment;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RequestManagerRetriever
implements Handler.Callback {
    @VisibleForTesting
    static final String FRAGMENT_TAG = "io.intercom.com.bumptech.glide.manager";
    private static final String TAG = "RMRetriever";
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final int ID_REMOVE_SUPPORT_FRAGMENT_MANAGER = 2;
    private static final String FRAGMENT_INDEX_KEY = "key";
    private volatile RequestManager applicationManager;
    @VisibleForTesting
    final Map<android.app.FragmentManager, RequestManagerFragment> pendingRequestManagerFragments = new HashMap<android.app.FragmentManager, RequestManagerFragment>();
    @VisibleForTesting
    final Map<FragmentManager, SupportRequestManagerFragment> pendingSupportRequestManagerFragments = new HashMap<FragmentManager, SupportRequestManagerFragment>();
    private final Handler handler;
    private final RequestManagerFactory factory;
    private final ArrayMap<View, android.support.v4.app.Fragment> tempViewToSupportFragment = new ArrayMap();
    private final ArrayMap<View, Fragment> tempViewToFragment = new ArrayMap();
    private final Bundle tempBundle = new Bundle();
    private static final RequestManagerFactory DEFAULT_FACTORY = new RequestManagerFactory(){

        @Override
        public RequestManager build(Glide glide, Lifecycle lifecycle, RequestManagerTreeNode requestManagerTreeNode, Context context) {
            return new RequestManager(glide, lifecycle, requestManagerTreeNode, context);
        }
    };

    public RequestManagerRetriever(@Nullable RequestManagerFactory factory2) {
        this.factory = factory2 != null ? factory2 : DEFAULT_FACTORY;
        this.handler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestManager getApplicationManager(Context context) {
        if (this.applicationManager == null) {
            RequestManagerRetriever requestManagerRetriever = this;
            synchronized (requestManagerRetriever) {
                if (this.applicationManager == null) {
                    Glide glide = Glide.get(context.getApplicationContext());
                    this.applicationManager = this.factory.build(glide, new ApplicationLifecycle(), new EmptyRequestManagerTreeNode(), context.getApplicationContext());
                }
            }
        }
        return this.applicationManager;
    }

    public RequestManager get(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("You cannot start a load on a null Context");
        }
        if (Util.isOnMainThread() && !(context instanceof Application)) {
            if (context instanceof FragmentActivity) {
                return this.get((FragmentActivity)context);
            }
            if (context instanceof Activity) {
                return this.get((Activity)context);
            }
            if (context instanceof ContextWrapper) {
                return this.get(((ContextWrapper)context).getBaseContext());
            }
        }
        return this.getApplicationManager(context);
    }

    public RequestManager get(FragmentActivity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed((Activity)activity);
        FragmentManager fm = activity.getSupportFragmentManager();
        return this.supportFragmentGet((Context)activity, fm, null);
    }

    public RequestManager get(android.support.v4.app.Fragment fragment) {
        Preconditions.checkNotNull(fragment.getActivity(), "You cannot start a load on a fragment before it is attached or after it is destroyed");
        if (Util.isOnBackgroundThread()) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        FragmentManager fm = fragment.getChildFragmentManager();
        return this.supportFragmentGet((Context)fragment.getActivity(), fm, fragment);
    }

    public RequestManager get(Activity activity) {
        if (Util.isOnBackgroundThread()) {
            return this.get(activity.getApplicationContext());
        }
        RequestManagerRetriever.assertNotDestroyed(activity);
        android.app.FragmentManager fm = activity.getFragmentManager();
        return this.fragmentGet((Context)activity, fm, null);
    }

    public RequestManager get(View view) {
        if (Util.isOnBackgroundThread()) {
            return this.get(view.getContext().getApplicationContext());
        }
        Preconditions.checkNotNull(view);
        Preconditions.checkNotNull(view.getContext(), "Unable to obtain a request manager for a view without a Context");
        Activity activity = this.findActivity(view.getContext());
        if (activity == null) {
            return this.get(view.getContext().getApplicationContext());
        }
        if (activity instanceof FragmentActivity) {
            android.support.v4.app.Fragment fragment = this.findSupportFragment(view, (FragmentActivity)activity);
            return fragment != null ? this.get(fragment) : this.get(activity);
        }
        Fragment fragment = this.findFragment(view, activity);
        if (fragment == null) {
            return this.get(activity);
        }
        return this.get(fragment);
    }

    private static void findAllSupportFragmentsWithViews(@Nullable Collection<android.support.v4.app.Fragment> topLevelFragments, Map<View, android.support.v4.app.Fragment> result) {
        if (topLevelFragments == null) {
            return;
        }
        for (android.support.v4.app.Fragment fragment : topLevelFragments) {
            if (fragment == null || fragment.getView() == null) continue;
            result.put(fragment.getView(), fragment);
            RequestManagerRetriever.findAllSupportFragmentsWithViews(fragment.getChildFragmentManager().getFragments(), result);
        }
    }

    @Nullable
    private android.support.v4.app.Fragment findSupportFragment(View target, FragmentActivity activity) {
        this.tempViewToSupportFragment.clear();
        RequestManagerRetriever.findAllSupportFragmentsWithViews(activity.getSupportFragmentManager().getFragments(), this.tempViewToSupportFragment);
        android.support.v4.app.Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (android.support.v4.app.Fragment)this.tempViewToSupportFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToSupportFragment.clear();
        return result;
    }

    @Nullable
    private Fragment findFragment(View target, Activity activity) {
        this.tempViewToFragment.clear();
        this.findAllFragmentsWithViews(activity.getFragmentManager(), this.tempViewToFragment);
        Fragment result = null;
        View activityRoot = activity.findViewById(0x1020002);
        View current = target;
        while (!current.equals(activityRoot) && (result = (Fragment)this.tempViewToFragment.get((Object)current)) == null && current.getParent() instanceof View) {
            current = (View)current.getParent();
        }
        this.tempViewToFragment.clear();
        return result;
    }

    @TargetApi(value=26)
    private void findAllFragmentsWithViews(android.app.FragmentManager fragmentManager, ArrayMap<View, Fragment> result) {
        if (Build.VERSION.SDK_INT >= 26) {
            for (Fragment fragment : fragmentManager.getFragments()) {
                if (fragment.getView() == null) continue;
                result.put((Object)fragment.getView(), (Object)fragment);
                this.findAllFragmentsWithViews(fragment.getChildFragmentManager(), result);
            }
        } else {
            this.findAllFragmentsWithViewsPreO(fragmentManager, result);
        }
    }

    private void findAllFragmentsWithViewsPreO(android.app.FragmentManager fragmentManager, ArrayMap<View, Fragment> result) {
        int index = 0;
        while (true) {
            this.tempBundle.putInt(FRAGMENT_INDEX_KEY, index++);
            Fragment fragment = null;
            try {
                fragment = fragmentManager.getFragment(this.tempBundle, FRAGMENT_INDEX_KEY);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fragment == null) break;
            if (fragment.getView() == null) continue;
            result.put((Object)fragment.getView(), (Object)fragment);
            if (Build.VERSION.SDK_INT < 17) continue;
            this.findAllFragmentsWithViews(fragment.getChildFragmentManager(), result);
        }
    }

    private Activity findActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return this.findActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    @TargetApi(value=17)
    private static void assertNotDestroyed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            throw new IllegalArgumentException("You cannot start a load for a destroyed activity");
        }
    }

    @TargetApi(value=17)
    public RequestManager get(Fragment fragment) {
        if (fragment.getActivity() == null) {
            throw new IllegalArgumentException("You cannot start a load on a fragment before it is attached");
        }
        if (Util.isOnBackgroundThread() || Build.VERSION.SDK_INT < 17) {
            return this.get(fragment.getActivity().getApplicationContext());
        }
        android.app.FragmentManager fm = fragment.getChildFragmentManager();
        return this.fragmentGet((Context)fragment.getActivity(), fm, fragment);
    }

    @TargetApi(value=17)
    RequestManagerFragment getRequestManagerFragment(android.app.FragmentManager fm, Fragment parentHint) {
        RequestManagerFragment current = (RequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null && (current = this.pendingRequestManagerFragments.get(fm)) == null) {
            current = new RequestManagerFragment();
            current.setParentFragmentHint(parentHint);
            this.pendingRequestManagerFragments.put(fm, current);
            fm.beginTransaction().add((Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(1, (Object)fm).sendToTarget();
        }
        return current;
    }

    private RequestManager fragmentGet(Context context, android.app.FragmentManager fm, Fragment parentHint) {
        RequestManagerFragment current = this.getRequestManagerFragment(fm, parentHint);
        RequestManager requestManager = current.getRequestManager();
        if (requestManager == null) {
            Glide glide = Glide.get(context);
            requestManager = this.factory.build(glide, current.getGlideLifecycle(), current.getRequestManagerTreeNode(), context);
            current.setRequestManager(requestManager);
        }
        return requestManager;
    }

    SupportRequestManagerFragment getSupportRequestManagerFragment(FragmentManager fm, android.support.v4.app.Fragment parentHint) {
        SupportRequestManagerFragment current = (SupportRequestManagerFragment)fm.findFragmentByTag(FRAGMENT_TAG);
        if (current == null && (current = this.pendingSupportRequestManagerFragments.get(fm)) == null) {
            current = new SupportRequestManagerFragment();
            current.setParentFragmentHint(parentHint);
            this.pendingSupportRequestManagerFragments.put(fm, current);
            fm.beginTransaction().add((android.support.v4.app.Fragment)current, FRAGMENT_TAG).commitAllowingStateLoss();
            this.handler.obtainMessage(2, (Object)fm).sendToTarget();
        }
        return current;
    }

    private RequestManager supportFragmentGet(Context context, FragmentManager fm, android.support.v4.app.Fragment parentHint) {
        SupportRequestManagerFragment current = this.getSupportRequestManagerFragment(fm, parentHint);
        RequestManager requestManager = current.getRequestManager();
        if (requestManager == null) {
            Glide glide = Glide.get(context);
            requestManager = this.factory.build(glide, current.getGlideLifecycle(), current.getRequestManagerTreeNode(), context);
            current.setRequestManager(requestManager);
        }
        return requestManager;
    }

    public boolean handleMessage(Message message) {
        boolean handled = true;
        Object removed = null;
        android.app.FragmentManager key = null;
        switch (message.what) {
            case 1: {
                android.app.FragmentManager fm;
                key = fm = (android.app.FragmentManager)message.obj;
                removed = this.pendingRequestManagerFragments.remove(fm);
                break;
            }
            case 2: {
                FragmentManager supportFm = (FragmentManager)message.obj;
                key = supportFm;
                removed = this.pendingSupportRequestManagerFragments.remove(supportFm);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled && removed == null && Log.isLoggable((String)TAG, (int)5)) {
            Log.w((String)TAG, (String)("Failed to remove expected request manager fragment, manager: " + key));
        }
        return handled;
    }

    public static interface RequestManagerFactory {
        public RequestManager build(Glide var1, Lifecycle var2, RequestManagerTreeNode var3, Context var4);
    }
}

