/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.errorreporting;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.errorreporting.ErrorReport;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.persistence.JsonStorage;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.com.google.gson.Gson;
import java.io.File;
import java.util.concurrent.RejectedExecutionException;

class ErrorReportStore {
    private static final String REPORT_FILE_PATH = "intercom-error.json";
    private static final Twig TWIG = LumberMill.getLogger();
    private final File reportFile;
    private final JsonStorage storage;

    public static ErrorReportStore create(Context appContext, Gson gson) {
        File reportFile = new File(appContext.getCacheDir(), REPORT_FILE_PATH);
        return new ErrorReportStore(reportFile, new JsonStorage(gson));
    }

    @VisibleForTesting
    ErrorReportStore(File reportFile, JsonStorage storage) {
        this.reportFile = reportFile;
        this.storage = storage;
    }

    void sendSavedReport(final Provider<Api> apiProvider) {
        try {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ErrorReportStore.this.reportFile.exists()) {
                        ErrorReportStore.this.readAndSendReport((Api)apiProvider.get());
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            TWIG.internal("Couldn't queue up sending of event: " + e);
        }
    }

    private void readAndSendReport(final Api api) {
        this.storage.loadThenDelete(this.reportFile, ErrorReport.class, new JsonStorage.LoadHandler<ErrorReport>(){

            @Override
            public void onLoad(ErrorReport report) {
                api.sendErrorReport(report);
            }
        });
    }

    void saveToDisk(ErrorReport report) {
        this.storage.saveToFileAsJson(report, this.reportFile);
    }

    void deleteFromDisk() {
        this.storage.loadThenDelete(this.reportFile, ErrorReport.class, new JsonStorage.LoadHandler<ErrorReport>(){

            @Override
            public void onLoad(ErrorReport report) {
            }
        });
    }
}

