/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.function;

import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.models.Part;
import java.util.Calendar;
import java.util.List;

public class TimestampAdder {
    private final Calendar currentDate;
    private final Calendar nextDate;

    public static TimestampAdder create() {
        return new TimestampAdder(Calendar.getInstance(), Calendar.getInstance());
    }

    TimestampAdder(Calendar currentDate, Calendar nextDate) {
        this.currentDate = currentDate;
        this.nextDate = nextDate;
    }

    public void addDayDividers(List<Part> parts) {
        this.currentDate.setTimeInMillis(0L);
        this.nextDate.setTimeInMillis(0L);
        for (int i = 0; i < parts.size(); ++i) {
            if (this.isDivider(parts.get(i))) continue;
            long partCreatedAt = parts.get(i).getCreatedAt();
            this.nextDate.setTimeInMillis(partCreatedAt * 1000L);
            if (this.datesAreFromDifferentDays() && (i == 0 || !this.isDivider(parts.get(i - 1)))) {
                parts.add(i, new Part.Builder().withStyle("day_divider_style").withCreatedAt(partCreatedAt).build());
                ++i;
            }
            this.currentDate.setTimeInMillis(this.nextDate.getTimeInMillis());
        }
    }

    private boolean isDivider(Part part) {
        return "day_divider_style".equals(part.getMessageStyle());
    }

    @VisibleForTesting
    boolean datesAreFromDifferentDays() {
        return this.currentDate.get(6) != this.nextDate.get(6) || this.currentDate.get(1) != this.nextDate.get(1);
    }
}

