/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.content.res.Resources;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.UnitModelLoader;
import java.io.InputStream;

public class ResourceLoader<Data>
implements ModelLoader<Integer, Data> {
    private static final String TAG = "ResourceLoader";
    private final ModelLoader<Uri, Data> uriLoader;
    private final Resources resources;

    public ResourceLoader(Resources resources, ModelLoader<Uri, Data> uriLoader) {
        this.resources = resources;
        this.uriLoader = uriLoader;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(Integer model, int width, int height, Options options) {
        Uri uri = this.getResourceUri(model);
        return uri == null ? null : this.uriLoader.buildLoadData(uri, width, height, options);
    }

    @Nullable
    private Uri getResourceUri(Integer model) {
        try {
            return Uri.parse((String)("android.resource://" + this.resources.getResourcePackageName(model.intValue()) + '/' + this.resources.getResourceTypeName(model.intValue()) + '/' + this.resources.getResourceEntryName(model.intValue())));
        }
        catch (Resources.NotFoundException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)("Received invalid resource id: " + model), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public boolean handles(Integer model) {
        return true;
    }

    public static class UriFactory
    implements ModelLoaderFactory<Integer, Uri> {
        private final Resources resources;

        public UriFactory(Resources resources) {
            this.resources = resources;
        }

        @Override
        public ModelLoader<Integer, Uri> build(MultiModelLoaderFactory multiFactory) {
            return new ResourceLoader<Uri>(this.resources, UnitModelLoader.getInstance());
        }

        @Override
        public void teardown() {
        }
    }

    public static class FileDescriptorFactory
    implements ModelLoaderFactory<Integer, ParcelFileDescriptor> {
        private final Resources resources;

        public FileDescriptorFactory(Resources resources) {
            this.resources = resources;
        }

        @Override
        public ModelLoader<Integer, ParcelFileDescriptor> build(MultiModelLoaderFactory multiFactory) {
            return new ResourceLoader<ParcelFileDescriptor>(this.resources, multiFactory.build(Uri.class, ParcelFileDescriptor.class));
        }

        @Override
        public void teardown() {
        }
    }

    public static class StreamFactory
    implements ModelLoaderFactory<Integer, InputStream> {
        private final Resources resources;

        public StreamFactory(Resources resources) {
            this.resources = resources;
        }

        @Override
        public ModelLoader<Integer, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new ResourceLoader<InputStream>(this.resources, multiFactory.build(Uri.class, InputStream.class));
        }

        @Override
        public void teardown() {
        }
    }
}

