/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import io.intercom.android.sdk.nexus.EventData;
import io.intercom.android.sdk.nexus.NexusEventType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class NexusEvent {
    static final String TOPIC_PREFIX_CONVERSATION = "conversation/";
    static final String EVENT_GUID = "eventGuid";
    static final String EVENT_DATA = "eventData";
    static final String EVENT_NAME = "eventName";
    static final String NX_TOPICS = "nx.Topics";
    static final String NX_TO_USER = "nx.ToUser";
    static final String NX_FROM_USER = "nx.FromUser";
    static final String ADMIN_ID = "adminId";
    static final String ADMIN_NAME = "adminName";
    static final String ADMIN_AVATAR = "adminAvatar";
    static final String ADMIN_TIMESTAMP = "adminTimestamp";
    static final String CONVERSATION_ID = "conversationId";
    static final String ASSIGNEE_ID = "assigneeId";
    private final NexusEventType eventType;
    private final EventData eventData;
    private final List<String> topics;
    private final String guid;
    private final String userId;

    public NexusEvent(Builder builder) {
        this.eventType = builder.eventName;
        this.eventData = new EventData();
        if (builder.eventData != null) {
            Set keys = builder.eventData.keySet();
            for (String key : keys) {
                Object object = builder.eventData.get(key);
                if (object == null) continue;
                this.eventData.put(key, object);
            }
        }
        this.topics = new ArrayList<String>();
        if (builder.topics != null) {
            for (String topic : builder.topics) {
                if (TextUtils.isEmpty((CharSequence)topic)) continue;
                this.topics.add(topic);
            }
        }
        this.guid = UUID.randomUUID().toString();
        this.userId = builder.userId != null ? builder.userId : "";
    }

    public NexusEvent(JSONObject jsonObject) {
        this.eventType = NexusEventType.safeValueOf(jsonObject.optString(EVENT_NAME));
        JSONObject eventDataJson = jsonObject.optJSONObject(EVENT_DATA);
        if (eventDataJson != null && eventDataJson.length() > 0) {
            this.eventData = new EventData(eventDataJson.length());
            Iterator keys = eventDataJson.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = eventDataJson.opt(key);
                if (value == null) continue;
                this.eventData.put(key, value);
            }
        } else {
            this.eventData = new EventData();
        }
        this.topics = new ArrayList<String>();
        JSONArray topicsArray = jsonObject.optJSONArray(NX_TOPICS);
        if (topicsArray != null) {
            for (int i = 0; i < topicsArray.length(); ++i) {
                String topic = topicsArray.optString(i);
                if (TextUtils.isEmpty((CharSequence)topic)) continue;
                this.topics.add(topic);
            }
        }
        this.guid = jsonObject.optString(EVENT_GUID);
        this.userId = jsonObject.has(NX_TO_USER) ? jsonObject.optString(NX_TO_USER) : jsonObject.optString(NX_FROM_USER);
    }

    public String toStringEncodedJsonObject() {
        return this.eventType.toStringEncodedJsonObject(this);
    }

    public NexusEventType getEventType() {
        return this.eventType;
    }

    public EventData getEventData() {
        return this.eventData;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getUserId() {
        return this.userId;
    }

    public static NexusEvent getAdminIsTypingEvent(String conversationId, String adminId, String adminName, String adminAvatarUrl, String userId) {
        EventData eventData = new EventData(4);
        eventData.put(CONVERSATION_ID, conversationId);
        eventData.put(ADMIN_ID, adminId);
        eventData.put(ADMIN_NAME, adminName);
        eventData.put(ADMIN_AVATAR, adminAvatarUrl);
        return new Builder(NexusEventType.AdminIsTyping).withEventData(eventData).withUserId(userId).withTopics(NexusEvent.conversationTopics(conversationId)).build();
    }

    public static NexusEvent getAdminIsTypingNoteEvent(String conversationId, String adminId, String adminName, String adminAvatarUrl, String userId) {
        EventData eventData = new EventData(4);
        eventData.put(ADMIN_ID, adminId);
        eventData.put(CONVERSATION_ID, conversationId);
        eventData.put(ADMIN_NAME, adminName);
        eventData.put(ADMIN_AVATAR, adminAvatarUrl);
        return new Builder(NexusEventType.AdminIsTypingANote).withEventData(eventData).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getUserIsTypingEvent(String conversationId, String userId) {
        EventData eventData = new EventData(1);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.UserIsTyping).withEventData(eventData).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getConversationSeenEvent(String conversationId, String userId) {
        EventData eventData = new EventData(1);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.ConversationSeen).withEventData(eventData).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getConversationSeenAdminEvent(String conversationId, String userId) {
        EventData eventData = new EventData(1);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.UserContentSeenByAdmin).withEventData(eventData).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getNewCommentEvent(String conversationId, String userId) {
        EventData eventData = new EventData(1);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.NewComment).withEventData(eventData).withTopics(NexusEvent.conversationTopics(conversationId)).withUserId(userId).build();
    }

    public static NexusEvent getNewNoteEvent(String conversationId, String adminId) {
        EventData eventData = new EventData(2);
        eventData.put(ADMIN_ID, adminId);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.NewNote).withEventData(eventData).build();
    }

    public static NexusEvent getConversationAssignedEvent(String conversationId, String adminId, String assigneeId) {
        EventData eventData = new EventData(3);
        eventData.put(ADMIN_ID, adminId);
        eventData.put(CONVERSATION_ID, conversationId);
        eventData.put(ASSIGNEE_ID, assigneeId);
        return new Builder(NexusEventType.ConversationAssigned).withEventData(eventData).build();
    }

    public static NexusEvent getConversationClosedEvent(String conversationId, String adminId) {
        EventData eventData = new EventData(2);
        eventData.put(ADMIN_ID, adminId);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.ConversationClosed).withEventData(eventData).build();
    }

    public static NexusEvent getConversationReopenedEvent(String conversationId, String adminId) {
        EventData eventData = new EventData(2);
        eventData.put(ADMIN_ID, adminId);
        eventData.put(CONVERSATION_ID, conversationId);
        return new Builder(NexusEventType.ConversationReopened).withEventData(eventData).build();
    }

    public static NexusEvent getUserPresenceEvent() {
        return new Builder(NexusEventType.UserPresence).build();
    }

    public static NexusEvent getSubscribeEvent(List<String> topics) {
        return new Builder(NexusEventType.Subscribe).withTopics(topics).build();
    }

    public static NexusEvent getUnsubscribeEvent(List<String> topics) {
        return new Builder(NexusEventType.Unsubscribe).withTopics(topics).build();
    }

    private static List<String> conversationTopics(String conversationId) {
        String subTopic = conversationId;
        if (TextUtils.isEmpty((CharSequence)conversationId)) {
            subTopic = "new";
        }
        return Collections.singletonList(TOPIC_PREFIX_CONVERSATION + subTopic);
    }

    static class Builder {
        final NexusEventType eventName;
        @Nullable
        EventData eventData;
        @Nullable
        List<String> topics;
        @Nullable
        String userId;

        Builder(NexusEventType name) {
            this.eventName = name;
        }

        public Builder withTopics(List<String> topics) {
            this.topics = topics;
            return this;
        }

        public Builder withEventData(EventData eventData) {
            this.eventData = eventData;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public NexusEvent build() {
            return new NexusEvent(this);
        }
    }
}

