/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.api.ShutdownState;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.MediaType;
import io.intercom.okhttp3.Response;
import io.intercom.okhttp3.ResponseBody;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class ShutdownInterceptor
implements Interceptor {
    private static final String ERROR = "error";
    private static final String TYPE = "type";
    private static final String MESSAGE = "message";
    private static final String MESSENGER_SHUTDOWN_RESPONSE = "messenger_shutdown_response";
    private static final String SHUTDOWN_PERIOD = "shutdown_period";
    private final ShutdownState shutdownState;
    private final Twig twig = LumberMill.getLogger();

    public ShutdownInterceptor(ShutdownState shutdownState) {
        this.shutdownState = shutdownState;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (!this.shutdownState.canSendNetworkRequests()) {
            this.twig.e(this.shutdownState.getShutdownReason(), new Object[0]);
            throw new IOException(this.shutdownState.getShutdownReason());
        }
        Response response = chain.proceed(chain.request());
        if (!response.isSuccessful()) {
            ResponseBody body = response.body();
            String bodyString = body.string();
            response = response.newBuilder().body(ResponseBody.create((MediaType)body.contentType(), (String)bodyString)).build();
            body.close();
            try {
                JSONObject errorResponse = new JSONObject(bodyString);
                JSONObject errorObject = errorResponse.getJSONObject(ERROR);
                if (errorObject.getString(TYPE).equals(MESSENGER_SHUTDOWN_RESPONSE)) {
                    long shutdownPeriod = errorObject.getLong(SHUTDOWN_PERIOD);
                    String shutdownReason = errorObject.getString(MESSAGE);
                    this.shutdownState.updateShutdownState(TimeUnit.SECONDS.toMillis(shutdownPeriod), shutdownReason);
                }
            }
            catch (JSONException ignored) {
                this.twig.internal("Failed to deserialise error response: `" + bodyString + "` message: `" + response.message() + "`");
            }
        }
        return response;
    }
}

