/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.engine.DecodeJob;
import io.intercom.com.bumptech.glide.load.engine.EngineJobListener;
import io.intercom.com.bumptech.glide.load.engine.EngineResource;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.executor.GlideExecutor;
import io.intercom.com.bumptech.glide.request.ResourceCallback;
import io.intercom.com.bumptech.glide.util.Util;
import io.intercom.com.bumptech.glide.util.pool.FactoryPools;
import io.intercom.com.bumptech.glide.util.pool.StateVerifier;
import java.util.ArrayList;
import java.util.List;

class EngineJob<R>
implements DecodeJob.Callback<R>,
FactoryPools.Poolable {
    private static final EngineResourceFactory DEFAULT_FACTORY = new EngineResourceFactory();
    private static final Handler MAIN_THREAD_HANDLER = new Handler(Looper.getMainLooper(), (Handler.Callback)new MainThreadCallback());
    private static final int MSG_COMPLETE = 1;
    private static final int MSG_EXCEPTION = 2;
    private static final int MSG_CANCELLED = 3;
    private final List<ResourceCallback> cbs = new ArrayList<ResourceCallback>(2);
    private final StateVerifier stateVerifier = StateVerifier.newInstance();
    private final Pools.Pool<EngineJob<?>> pool;
    private final EngineResourceFactory engineResourceFactory;
    private final EngineJobListener listener;
    private final GlideExecutor diskCacheExecutor;
    private final GlideExecutor sourceExecutor;
    private final GlideExecutor sourceUnlimitedExecutor;
    private final GlideExecutor animationExecutor;
    private Key key;
    private boolean isCacheable;
    private boolean useUnlimitedSourceGeneratorPool;
    private boolean useAnimationPool;
    private boolean onlyRetrieveFromCache;
    private Resource<?> resource;
    private DataSource dataSource;
    private boolean hasResource;
    private GlideException exception;
    private boolean hasLoadFailed;
    private List<ResourceCallback> ignoredCallbacks;
    private EngineResource<?> engineResource;
    private DecodeJob<R> decodeJob;
    private volatile boolean isCancelled;

    EngineJob(GlideExecutor diskCacheExecutor, GlideExecutor sourceExecutor, GlideExecutor sourceUnlimitedExecutor, GlideExecutor animationExecutor, EngineJobListener listener, Pools.Pool<EngineJob<?>> pool) {
        this(diskCacheExecutor, sourceExecutor, sourceUnlimitedExecutor, animationExecutor, listener, pool, DEFAULT_FACTORY);
    }

    @VisibleForTesting
    EngineJob(GlideExecutor diskCacheExecutor, GlideExecutor sourceExecutor, GlideExecutor sourceUnlimitedExecutor, GlideExecutor animationExecutor, EngineJobListener listener, Pools.Pool<EngineJob<?>> pool, EngineResourceFactory engineResourceFactory) {
        this.diskCacheExecutor = diskCacheExecutor;
        this.sourceExecutor = sourceExecutor;
        this.sourceUnlimitedExecutor = sourceUnlimitedExecutor;
        this.animationExecutor = animationExecutor;
        this.listener = listener;
        this.pool = pool;
        this.engineResourceFactory = engineResourceFactory;
    }

    @VisibleForTesting
    EngineJob<R> init(Key key, boolean isCacheable, boolean useUnlimitedSourceGeneratorPool, boolean useAnimationPool, boolean onlyRetrieveFromCache) {
        this.key = key;
        this.isCacheable = isCacheable;
        this.useUnlimitedSourceGeneratorPool = useUnlimitedSourceGeneratorPool;
        this.useAnimationPool = useAnimationPool;
        this.onlyRetrieveFromCache = onlyRetrieveFromCache;
        return this;
    }

    public void start(DecodeJob<R> decodeJob) {
        this.decodeJob = decodeJob;
        GlideExecutor executor = decodeJob.willDecodeFromCache() ? this.diskCacheExecutor : this.getActiveSourceExecutor();
        executor.execute(decodeJob);
    }

    void addCallback(ResourceCallback cb) {
        Util.assertMainThread();
        this.stateVerifier.throwIfRecycled();
        if (this.hasResource) {
            cb.onResourceReady(this.engineResource, this.dataSource);
        } else if (this.hasLoadFailed) {
            cb.onLoadFailed(this.exception);
        } else {
            this.cbs.add(cb);
        }
    }

    void removeCallback(ResourceCallback cb) {
        Util.assertMainThread();
        this.stateVerifier.throwIfRecycled();
        if (this.hasResource || this.hasLoadFailed) {
            this.addIgnoredCallback(cb);
        } else {
            this.cbs.remove(cb);
            if (this.cbs.isEmpty()) {
                this.cancel();
            }
        }
    }

    boolean onlyRetrieveFromCache() {
        return this.onlyRetrieveFromCache;
    }

    private GlideExecutor getActiveSourceExecutor() {
        return this.useUnlimitedSourceGeneratorPool ? this.sourceUnlimitedExecutor : (this.useAnimationPool ? this.animationExecutor : this.sourceExecutor);
    }

    private void addIgnoredCallback(ResourceCallback cb) {
        if (this.ignoredCallbacks == null) {
            this.ignoredCallbacks = new ArrayList<ResourceCallback>(2);
        }
        if (!this.ignoredCallbacks.contains(cb)) {
            this.ignoredCallbacks.add(cb);
        }
    }

    private boolean isInIgnoredCallbacks(ResourceCallback cb) {
        return this.ignoredCallbacks != null && this.ignoredCallbacks.contains(cb);
    }

    void cancel() {
        if (this.hasLoadFailed || this.hasResource || this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        this.decodeJob.cancel();
        this.listener.onEngineJobCancelled(this, this.key);
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    void handleResultOnMainThread() {
        this.stateVerifier.throwIfRecycled();
        if (this.isCancelled) {
            this.resource.recycle();
            this.release(false);
            return;
        }
        if (this.cbs.isEmpty()) {
            throw new IllegalStateException("Received a resource without any callbacks to notify");
        }
        if (this.hasResource) {
            throw new IllegalStateException("Already have resource");
        }
        this.engineResource = this.engineResourceFactory.build(this.resource, this.isCacheable);
        this.hasResource = true;
        this.engineResource.acquire();
        this.listener.onEngineJobComplete(this, this.key, this.engineResource);
        int size = this.cbs.size();
        for (int i = 0; i < size; ++i) {
            ResourceCallback cb = this.cbs.get(i);
            if (this.isInIgnoredCallbacks(cb)) continue;
            this.engineResource.acquire();
            cb.onResourceReady(this.engineResource, this.dataSource);
        }
        this.engineResource.release();
        this.release(false);
    }

    void handleCancelledOnMainThread() {
        this.stateVerifier.throwIfRecycled();
        if (!this.isCancelled) {
            throw new IllegalStateException("Not cancelled");
        }
        this.listener.onEngineJobCancelled(this, this.key);
        this.release(false);
    }

    private void release(boolean isRemovedFromQueue) {
        Util.assertMainThread();
        this.cbs.clear();
        this.key = null;
        this.engineResource = null;
        this.resource = null;
        if (this.ignoredCallbacks != null) {
            this.ignoredCallbacks.clear();
        }
        this.hasLoadFailed = false;
        this.isCancelled = false;
        this.hasResource = false;
        this.decodeJob.release(isRemovedFromQueue);
        this.decodeJob = null;
        this.exception = null;
        this.dataSource = null;
        this.pool.release((Object)this);
    }

    @Override
    public void onResourceReady(Resource<R> resource, DataSource dataSource) {
        this.resource = resource;
        this.dataSource = dataSource;
        MAIN_THREAD_HANDLER.obtainMessage(1, (Object)this).sendToTarget();
    }

    @Override
    public void onLoadFailed(GlideException e) {
        this.exception = e;
        MAIN_THREAD_HANDLER.obtainMessage(2, (Object)this).sendToTarget();
    }

    @Override
    public void reschedule(DecodeJob<?> job) {
        this.getActiveSourceExecutor().execute(job);
    }

    void handleExceptionOnMainThread() {
        this.stateVerifier.throwIfRecycled();
        if (this.isCancelled) {
            this.release(false);
            return;
        }
        if (this.cbs.isEmpty()) {
            throw new IllegalStateException("Received an exception without any callbacks to notify");
        }
        if (this.hasLoadFailed) {
            throw new IllegalStateException("Already failed once");
        }
        this.hasLoadFailed = true;
        this.listener.onEngineJobComplete(this, this.key, null);
        for (ResourceCallback cb : this.cbs) {
            if (this.isInIgnoredCallbacks(cb)) continue;
            cb.onLoadFailed(this.exception);
        }
        this.release(false);
    }

    @Override
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    private static class MainThreadCallback
    implements Handler.Callback {
        MainThreadCallback() {
        }

        public boolean handleMessage(Message message) {
            EngineJob job = (EngineJob)message.obj;
            switch (message.what) {
                case 1: {
                    job.handleResultOnMainThread();
                    break;
                }
                case 2: {
                    job.handleExceptionOnMainThread();
                    break;
                }
                case 3: {
                    job.handleCancelledOnMainThread();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized message: " + message.what);
                }
            }
            return true;
        }
    }

    @VisibleForTesting
    static class EngineResourceFactory {
        EngineResourceFactory() {
        }

        public <R> EngineResource<R> build(Resource<R> resource, boolean isMemoryCacheable) {
            return new EngineResource<R>(resource, isMemoryCacheable, true);
        }
    }
}

