/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.commons.utilities;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;

public class BitmapUtils {
    public static Bitmap transformRound(Bitmap source, BitmapCache bitmapCache) {
        int size = Math.min(source.getWidth(), source.getHeight());
        int width = (source.getWidth() - size) / 2;
        int height = (source.getHeight() - size) / 2;
        Bitmap bitmap = bitmapCache.get(size, size, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        if (width != 0 || height != 0) {
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)(-width), (float)(-height));
            shader.setLocalMatrix(matrix);
        }
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        float r = (float)size / 2.0f;
        canvas.drawCircle(r, r, r, paint);
        return bitmap;
    }

    public static Bitmap transformRound(Bitmap source, BitmapCache bitmapCache, int borderColor, int borderWidth) {
        int size = Math.min(source.getWidth(), source.getHeight());
        float radius = (float)size / 2.0f;
        Bitmap bitmap = bitmapCache.get(size, size, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        Canvas canvas = new Canvas(bitmap);
        float cx = (source.getWidth() - borderWidth) / 2 + borderWidth / 2;
        float cy = (source.getHeight() - borderWidth) / 2 + borderWidth / 2;
        canvas.drawCircle(cx, cy, radius - (float)borderWidth, paint);
        Paint border = new Paint();
        border.setColor(borderColor);
        border.setStyle(Paint.Style.STROKE);
        border.setAntiAlias(true);
        border.setStrokeWidth(2.0f);
        canvas.drawCircle(cx, cy, radius - (float)borderWidth, border);
        return bitmap;
    }

    public static Bitmap transformRoundCorners(Bitmap source, BitmapCache bitmapCache, int radius) {
        int height;
        int width = source.getWidth();
        Bitmap bitmap = bitmapCache.get(width, height = source.getHeight(), Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)width, (float)height), (float)radius, (float)radius, paint);
        return bitmap;
    }

    public static Bitmap transformRoundCorners(Bitmap source, BitmapCache bitmapCache, int width, int height, int radius, int borderColor, int borderWidth) {
        Bitmap bitmap = bitmapCache.get(width, height, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap resized = Bitmap.createScaledBitmap((Bitmap)source, (int)width, (int)height, (boolean)false);
        paint.setShader((Shader)new BitmapShader(resized, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        RectF roundRect = new RectF((float)borderWidth, (float)borderWidth, (float)(width - borderWidth), (float)(height - borderWidth));
        canvas.drawRoundRect(roundRect, (float)radius, (float)radius, paint);
        Paint border = new Paint();
        border.setColor(borderColor);
        border.setStyle(Paint.Style.STROKE);
        border.setAntiAlias(true);
        border.setStrokeWidth((float)borderWidth);
        canvas.drawRoundRect(roundRect, (float)radius, (float)radius, border);
        return bitmap;
    }

    public static interface BitmapCache {
        public Bitmap get(int var1, int var2, Bitmap.Config var3);
    }
}

