/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.text.format.DateFormat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.utilities.Phrase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeFormatter {
    private final Context context;
    private final TimeProvider timeProvider;
    private SimpleDateFormat absoluteDateFormatter;
    private SimpleDateFormat absoluteTimeFormatter;

    public TimeFormatter(Context context, TimeProvider timeProvider) {
        this.context = context;
        this.timeProvider = timeProvider;
    }

    public CharSequence getFormattedTime(long time) {
        if (time <= 0L) {
            return "";
        }
        Date date = new Date(time * 1000L);
        return this.getFormattedTime(date);
    }

    private CharSequence getFormattedTime(Date date) {
        Phrase displayDate;
        long diffInMin = this.getDifferenceInMinutes(date);
        long diffInHours = this.getDifferenceInHours(date);
        long diffInDays = this.getDifferenceInDays(date);
        long diffInWeeks = diffInDays / 7L;
        if (diffInWeeks > 0L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_week_ago).put("delta", Long.toString(diffInWeeks));
        } else if (diffInDays > 0L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_day_ago).put("delta", Long.toString(diffInDays));
        } else if (diffInHours > 0L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_hour_ago).put("delta", Long.toString(diffInHours));
        } else if (diffInMin >= 1L) {
            displayDate = Phrase.from(this.context, R.string.intercom_time_minute_ago).put("delta", Long.toString(diffInMin));
        } else {
            return this.context.getText(R.string.intercom_time_just_now);
        }
        return displayDate.format();
    }

    public String getLastActiveMinutes(long time) {
        Date date = new Date(time * 1000L);
        return this.getDifferenceInMinutes(date) + " minutes";
    }

    public CharSequence getAdminActiveStatus(LastParticipatingAdmin admin, Provider<AppConfig> appConfigProvider) {
        if (this.shouldShowActiveOrAwayState(appConfigProvider.get().getLocale())) {
            return admin.isActive() ? this.context.getString(R.string.intercom_active_state) : this.context.getString(R.string.intercom_away_state);
        }
        if (admin.getLastActiveAt() <= 0L) {
            return "";
        }
        return this.getAdminActiveStatus(this.getDateFromTimeStamp(admin.getLastActiveAt()));
    }

    private CharSequence getAdminActiveStatus(Date date) {
        long diffInMin = this.getDifferenceInMinutes(date);
        if (diffInMin > TimeUnit.DAYS.toMinutes(6L)) {
            return this.context.getText(R.string.intercom_active_week_ago);
        }
        Phrase displayDate = diffInMin >= TimeUnit.HOURS.toMinutes(23L) + 31L ? Phrase.from(this.context, R.string.intercom_active_day_ago).put("days", Long.toString(1L + (diffInMin / 60L - 13L) / 24L)) : (diffInMin >= 53L ? Phrase.from(this.context, R.string.intercom_active_hour_ago).put("hours", Long.toString(1L + (diffInMin - 31L) / 60L)) : (diffInMin >= 38L ? Phrase.from(this.context, R.string.intercom_active_minute_ago).put("minutes", Long.toString(45L)) : (diffInMin >= 16L ? Phrase.from(this.context, R.string.intercom_active_minute_ago).put("minutes", Long.toString(30L)) : Phrase.from(this.context, R.string.intercom_active_15m_ago).put("minutes", Long.toString(15L)))));
        return displayDate.format();
    }

    @VisibleForTesting
    boolean shouldShowActiveOrAwayState(String locale) {
        return locale.equals("en");
    }

    private long getDifferenceInMinutes(Date date) {
        return TimeUnit.MILLISECONDS.toMinutes(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    private long getDifferenceInHours(Date date) {
        return TimeUnit.MILLISECONDS.toHours(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    private long getDifferenceInDays(Date date) {
        return TimeUnit.MILLISECONDS.toDays(this.timeProvider.currentTimeMillis() - date.getTime());
    }

    private Date getDateFromTimeStamp(long time) {
        return new Date(time * 1000L);
    }

    public String getAbsoluteDate(long timeInSeconds) {
        return this.getAbsoluteDate(timeInSeconds * 1000L, this.context.getResources().getConfiguration().locale);
    }

    @VisibleForTesting
    String getAbsoluteDate(long timeInMillis, Locale locale) {
        if (this.absoluteDateFormatter == null) {
            this.absoluteDateFormatter = TimeFormatter.createDateFormatter(locale, "MMMM d");
        }
        return this.absoluteDateFormatter.format(new Date(timeInMillis));
    }

    public String getAbsoluteTime(long timeInSeconds) {
        return this.getAbsoluteTime(timeInSeconds * 1000L, this.context.getResources().getConfiguration().locale);
    }

    @VisibleForTesting
    String getAbsoluteTime(long timeInMillis, Locale locale) {
        if (this.absoluteTimeFormatter == null) {
            this.absoluteTimeFormatter = TimeFormatter.createDateFormatter(locale, "hh:mm");
        }
        return this.absoluteTimeFormatter.format(new Date(timeInMillis));
    }

    private static SimpleDateFormat createDateFormatter(Locale locale, String template) {
        if (Build.VERSION.SDK_INT >= 18) {
            return new SimpleDateFormat(DateFormat.getBestDateTimePattern((Locale)locale, (String)template), locale);
        }
        return new SimpleDateFormat(template, locale);
    }

    public CharSequence getUpdated(long time) {
        Date date = this.getDateFromTimeStamp(time);
        long diffInMin = this.getDifferenceInMinutes(date);
        long diffInHours = this.getDifferenceInHours(date);
        long diffInDays = this.getDifferenceInDays(date);
        long diffInWeeks = diffInDays / 7L;
        if (diffInWeeks > 0L) {
            return "Updated " + diffInWeeks + " weeks ago";
        }
        if (diffInDays > 0L) {
            return "Updated " + diffInDays + " days ago";
        }
        if (diffInHours > 0L) {
            return "Updated " + diffInHours + " hours ago";
        }
        if (diffInMin >= 1L) {
            return "Updated " + diffInMin + " minutes ago";
        }
        return this.context.getText(R.string.intercom_time_just_now);
    }

    public static String formatTimeInMillisAsDate(long timeInMillis) {
        Date date = new Date(timeInMillis);
        return new SimpleDateFormat("MMM dd, yyyy", Locale.getDefault()).format(date);
    }
}

