/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.support.annotation.Nullable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class CustomAttributeValidator {
    private static final List<? extends Class<? extends Serializable>> ACCEPTED_CUSTOM_ATTRIBUTE_TYPES = Arrays.asList(String.class, Character.class, Short.class, Long.class, Float.class, Double.class, Integer.class, Byte.class, Boolean.class);

    public static boolean isValid(@Nullable Object attribute) {
        return attribute == null || ACCEPTED_CUSTOM_ATTRIBUTE_TYPES.contains(attribute.getClass());
    }

    public static String getAcceptedTypes() {
        StringBuilder classNames = new StringBuilder();
        for (Class<? extends Serializable> clazz : ACCEPTED_CUSTOM_ATTRIBUTE_TYPES) {
            if (classNames.length() != 0) {
                classNames.append(", ");
            }
            classNames.append(clazz.getSimpleName());
        }
        return classNames.toString();
    }
}

