/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.view.View;
import io.intercom.android.sdk.R;

public class BackgroundUtils {
    public static void setBackground(View background, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            background.setBackground(drawable2);
        } else {
            background.setBackgroundDrawable(drawable2);
        }
    }

    public static void animateBackground(int colorFrom, int colorTo, int duration, final View view, Animator.AnimatorListener animatationListener) {
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration((long)duration);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        if (animatationListener != null) {
            colorAnimation.addListener(animatationListener);
        }
        colorAnimation.start();
    }

    public static void setRippleButtonStroke(Context context, Drawable buttonBackground, @IdRes int layerId, @ColorInt int strokeColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            RippleDrawable rippleDrawable = (RippleDrawable)buttonBackground;
            GradientDrawable background = (GradientDrawable)rippleDrawable.findDrawableByLayerId(layerId);
            BackgroundUtils.updateStroke(background, context, strokeColor);
        } else {
            LayerDrawable layerDrawable = (LayerDrawable)buttonBackground;
            GradientDrawable background = (GradientDrawable)layerDrawable.findDrawableByLayerId(layerId);
            BackgroundUtils.updateStroke(background, context, strokeColor);
        }
    }

    private static void updateStroke(GradientDrawable background, Context context, @ColorInt int color2) {
        int strokeSize = context.getResources().getDimensionPixelSize(R.dimen.intercom_home_button_stroke_size);
        background.setStroke(strokeSize, color2);
    }
}

