/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.support.v4.util.Pools;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.DataRewinder;
import io.intercom.com.bumptech.glide.load.engine.DecodePath;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LoadPath<Data, ResourceType, Transcode> {
    private final Class<Data> dataClass;
    private final Pools.Pool<List<Throwable>> listPool;
    private final List<? extends DecodePath<Data, ResourceType, Transcode>> decodePaths;
    private final String failureMessage;

    public LoadPath(Class<Data> dataClass, Class<ResourceType> resourceClass, Class<Transcode> transcodeClass, List<DecodePath<Data, ResourceType, Transcode>> decodePaths, Pools.Pool<List<Throwable>> listPool) {
        this.dataClass = dataClass;
        this.listPool = listPool;
        this.decodePaths = Preconditions.checkNotEmpty(decodePaths);
        this.failureMessage = "Failed LoadPath{" + dataClass.getSimpleName() + "->" + resourceClass.getSimpleName() + "->" + transcodeClass.getSimpleName() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<Transcode> load(DataRewinder<Data> rewinder, Options options, int width, int height, DecodePath.DecodeCallback<ResourceType> decodeCallback) throws GlideException {
        List throwables = (List)Preconditions.checkNotNull(this.listPool.acquire());
        try {
            Resource<Transcode> resource = this.loadWithExceptionList(rewinder, options, width, height, decodeCallback, throwables);
            return resource;
        }
        finally {
            this.listPool.release((Object)throwables);
        }
    }

    private Resource<Transcode> loadWithExceptionList(DataRewinder<Data> rewinder, Options options, int width, int height, DecodePath.DecodeCallback<ResourceType> decodeCallback, List<Throwable> exceptions) throws GlideException {
        int size = this.decodePaths.size();
        Resource<Transcode> result = null;
        for (int i = 0; i < size; ++i) {
            DecodePath<Data, ResourceType, Transcode> path = this.decodePaths.get(i);
            try {
                result = path.decode(rewinder, width, height, options, decodeCallback);
            }
            catch (GlideException e) {
                exceptions.add(e);
            }
            if (result != null) break;
        }
        if (result == null) {
            throw new GlideException(this.failureMessage, new ArrayList<Throwable>(exceptions));
        }
        return result;
    }

    public Class<Data> getDataClass() {
        return this.dataClass;
    }

    public String toString() {
        return "LoadPath{decodePaths=" + Arrays.toString(this.decodePaths.toArray(new DecodePath[this.decodePaths.size()])) + '}';
    }
}

