/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryInputDataSource;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryLightBoxFragment;
import com.intercom.input.gallery.LocalImagesDataSource;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.composer.galleryinput.DownscaleOnlyCenterCrop;
import io.intercom.android.sdk.conversation.composer.galleryinput.GalleryImageLoader;
import io.intercom.android.sdk.conversation.composer.galleryinput.LocalGalleryLightBoxFragment;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapTransformation;

class LocalGalleryInputInjector
implements GalleryInputFragment.Injector {
    private final RequestManager requestManager;

    public LocalGalleryInputInjector(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    @Nullable
    public View getExpanderButton(ViewGroup parent) {
        ImageButton expander = (ImageButton)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.intercom_expander_button, parent, false);
        expander.setColorFilter(this.getThemeColor(expander.getContext()));
        return expander;
    }

    @Nullable
    public View getSearchView(ViewGroup parent) {
        return null;
    }

    public Toolbar getToolbar(ViewGroup parent) {
        return (Toolbar)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.intercom_gallery_input_toolbar, parent, false);
    }

    public int getThemeColor(Context context) {
        AppConfig appConfig = Injector.get().getAppConfigProvider().get();
        return ColorUtils.primaryOrDarkColor(context, appConfig);
    }

    public GalleryInputDataSource getDataSource(GalleryInputFragment fragment) {
        return LocalImagesDataSource.create((GalleryInputFragment)fragment);
    }

    public ImageLoader getImageLoader(GalleryInputFragment fragment) {
        return GalleryImageLoader.create(DiskCacheStrategy.NONE, (BitmapTransformation)DownscaleOnlyCenterCrop.INSTANCE, this.requestManager);
    }

    public Class<? extends GalleryLightBoxFragment> getLightBoxFragmentClass(GalleryInputFragment fragment) {
        return LocalGalleryLightBoxFragment.class;
    }

    public String getEmptyViewTitle(Resources resources) {
        return resources.getString(R.string.intercom_no_photos);
    }

    public String getEmptyViewSubtitle(Resources resources) {
        return resources.getString(R.string.intercom_no_photos_on_device);
    }

    public String getErrorViewTitle(Resources resources) {
        return null;
    }

    public String getErrorViewSubtitle(Resources resources) {
        return null;
    }
}

