/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.views.ActiveStatePresenter;
import io.intercom.android.sdk.views.BackButtonCountDrawable;
import io.intercom.com.bumptech.glide.RequestManager;

public class IntercomToolbar
extends Toolbar
implements View.OnTouchListener,
View.OnClickListener {
    private static final int TITLE_FADE_DURATION_MS = 150;
    private final BackButtonCountDrawable backButtonCountDrawable;
    final TextView title;
    private final TextView subtitle;
    private final ImageButton close;
    private final ImageButton backButton;
    private final ImageView avatar;
    private final View activeStateView;
    @Nullable
    private Listener listener;

    public IntercomToolbar(Context context) {
        this(context, null);
    }

    public IntercomToolbar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        View toolbar = IntercomToolbar.inflate((Context)context, (int)R.layout.intercom_toolbar, (ViewGroup)this);
        toolbar.setOnTouchListener((View.OnTouchListener)this);
        this.title = (TextView)toolbar.findViewById(R.id.intercom_toolbar_title);
        this.subtitle = (TextView)toolbar.findViewById(R.id.intercom_toolbar_subtitle);
        this.close = (ImageButton)toolbar.findViewById(R.id.intercom_toolbar_close);
        this.backButton = (ImageButton)toolbar.findViewById(R.id.intercom_toolbar_inbox);
        this.avatar = (ImageView)toolbar.findViewById(R.id.intercom_toolbar_avatar);
        this.activeStateView = toolbar.findViewById(R.id.intercom_toolbar_avatar_active_state);
        this.backButtonCountDrawable = new BackButtonCountDrawable(this.getContext(), null);
        this.backButton.setImageDrawable((Drawable)this.backButtonCountDrawable);
        this.backButton.setOnClickListener((View.OnClickListener)this);
        this.close.setOnClickListener((View.OnClickListener)this);
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    public void setCloseButtonVisibility(int visibility) {
        this.close.setVisibility(visibility);
    }

    public void setSubtitleVisibility(int visibility) {
        this.subtitle.setVisibility(visibility);
    }

    public void setUpPostToolbar(Participant participant, boolean active, ActiveStatePresenter activeStatePresenter, AppConfig appConfig, RequestManager requestManager) {
        this.setBackgroundColor(0);
        this.title.setTextColor(-1);
        this.close.setColorFilter(-1);
        this.backButton.setVisibility(8);
        this.avatar.setVisibility(0);
        this.activeStateView.setVisibility(0);
        this.title.setTextSize(14.0f);
        this.subtitle.setAlpha(0.7f);
        this.findViewById(R.id.intercom_toolbar_divider).setVisibility(0);
        AvatarUtils.loadAvatarIntoView(participant.getAvatar(), this.avatar, appConfig, requestManager);
        activeStatePresenter.presentStateDot(active, this.activeStateView, appConfig);
    }

    public void setUpNoteToolbar(Participant participant, boolean active, ActiveStatePresenter activeStatePresenter, AppConfig appConfig, RequestManager requestManager) {
        this.title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_note_title_grey));
        this.subtitle.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_note_grey));
        this.close.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.intercom_grey_500));
        this.backButton.setVisibility(8);
        this.avatar.setVisibility(0);
        this.activeStateView.setVisibility(0);
        this.title.setTextSize(14.0f);
        this.subtitle.setAlpha(1.0f);
        View divider = this.findViewById(R.id.intercom_toolbar_divider);
        divider.setVisibility(0);
        divider.setBackgroundColor(-16777216);
        AvatarUtils.loadAvatarIntoView(participant.getAvatar(), this.avatar, appConfig, requestManager);
        activeStatePresenter.presentStateDot(active, this.activeStateView, appConfig);
    }

    public void setInboxButtonVisibility(int visible) {
        this.backButton.setVisibility(visible);
    }

    public void setTitle(CharSequence titleText) {
        if (TextUtils.isEmpty((CharSequence)titleText)) {
            this.fadeOutTitle(150);
        } else {
            this.title.setAlpha(1.0f);
            this.title.setText(titleText);
        }
    }

    public void setTitleAnimated(CharSequence titleText) {
        if (TextUtils.isEmpty((CharSequence)titleText)) {
            this.fadeOutTitle(150);
        } else {
            this.title.setAlpha(0.0f);
            this.title.setText(titleText);
            this.title.animate().alpha(1.0f).setDuration(150L).start();
        }
    }

    public void setSubtitle(@Nullable CharSequence subtitleText) {
        this.subtitle.setText(subtitleText);
        if (!TextUtils.isEmpty((CharSequence)subtitleText)) {
            this.subtitle.setAlpha(1.0f);
        }
    }

    public void fadeOutTitle(int durationMs) {
        this.title.animate().alpha(0.0f).setDuration((long)durationMs).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomToolbar.this.title.setText(null);
            }
        }).start();
    }

    public void onClick(View view) {
        if (this.listener == null) {
            return;
        }
        int id2 = view.getId();
        if (id2 == R.id.intercom_toolbar_close) {
            this.listener.onCloseClicked();
        } else if (id2 == R.id.intercom_toolbar_inbox) {
            this.listener.onInboxClicked();
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.listener == null) {
            return false;
        }
        if (motionEvent.getAction() == 1 && view.getId() == R.id.intercom_toolbar) {
            this.listener.onToolbarClicked();
        }
        return false;
    }

    public void setUnreadCount(Integer unreadCount) {
        this.backButtonCountDrawable.setText(unreadCount > 0 ? Integer.toString(unreadCount) : null);
    }

    public static interface Listener {
        public void onCloseClicked();

        public void onToolbarClicked();

        public void onInboxClicked();
    }
}

