/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.transforms.RoundTransform;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.AvatarDefaultDrawable;
import io.intercom.android.sdk.views.AvatarInitialsDrawable;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.SimpleTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import java.io.File;

public class AvatarUtils {
    public static void preloadAvatar(Avatar avatar, final Runnable runnable, RequestManager requestManager) {
        if (avatar.getImageUrl().isEmpty()) {
            runnable.run();
        } else {
            requestManager.downloadOnly().load(avatar.getImageUrl()).into((Target)new SimpleTarget<File>(){

                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                    runnable.run();
                }

                public void onResourceReady(File file, Transition<? super File> transition) {
                    runnable.run();
                }
            });
        }
    }

    public static void loadAvatarIntoView(Avatar avatar, ImageView imageView, AppConfig appConfig, RequestManager requestManager) {
        AvatarUtils.createAvatar(avatar, imageView, 0, appConfig, requestManager);
    }

    public static void createAvatar(Avatar avatar, ImageView imageView, int size, AppConfig appConfig, RequestManager requestManager) {
        Context context = imageView.getContext();
        Drawable backupDrawable = avatar.getInitials().isEmpty() ? AvatarUtils.getDefaultDrawable(context, appConfig) : AvatarUtils.getInitialsDrawable(avatar.getInitials(), appConfig);
        RequestOptions options = new RequestOptions().placeholder(backupDrawable).error(backupDrawable).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(avatar.getImageUrl())).transform((Transformation)new RoundTransform());
        if (size > 0) {
            options = options.override(size, size);
        }
        requestManager.load(avatar.getImageUrl()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).apply(options).into(imageView);
    }

    public static AvatarInitialsDrawable getInitialsDrawable(String initials, AppConfig appConfig) {
        return new AvatarInitialsDrawable(initials.toUpperCase(), appConfig.getBaseColorDark());
    }

    public static AvatarDefaultDrawable getDefaultDrawable(Context context, AppConfig appConfig) {
        return new AvatarDefaultDrawable(context, appConfig.getBaseColorDark());
    }
}

