/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.UserUpdateBatcher;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;

public class UserUpdateBatcherMiddleware
implements Store.Middleware<State> {
    private final Provider<AppConfig> appConfigProvider;
    private final Provider<UserUpdateBatcher> userUpdateBatcher;
    private final Provider<UserIdentity> userIdentityProvider;

    public UserUpdateBatcherMiddleware(Provider<UserUpdateBatcher> userUpdateBatcher, Provider<AppConfig> appConfigProvider, Provider<UserIdentity> userIdentityProvider) {
        this.appConfigProvider = appConfigProvider;
        this.userUpdateBatcher = userUpdateBatcher;
        this.userIdentityProvider = userIdentityProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case APP_ENTERED_FOREGROUND: {
                long currentTime = (Long)action.value();
                long timeSinceBackgrounded = currentTime - store.state().hostAppState().backgroundedTimestamp();
                if (timeSinceBackgrounded <= this.appConfigProvider.get().getNewSessionThresholdMs() || !this.userIdentityProvider.get().identityExists() || store.select(Selectors.SESSION_STARTED_SINCE_LAST_BACKGROUNDED).booleanValue()) break;
                Boolean isBackgrounded = store.select(Selectors.APP_IS_BACKGROUNDED);
                this.userUpdateBatcher.get().updateUser(new UserUpdateRequest(true, isBackgrounded, true));
                break;
            }
        }
    }
}

