/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.provider;

import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import java.util.ArrayList;
import java.util.List;

public class ResourceDecoderRegistry {
    private final List<Entry<?, ?>> decoders = new ArrayList();

    public synchronized <T, R> List<ResourceDecoder<T, R>> getDecoders(Class<T> dataClass, Class<R> resourceClass) {
        ArrayList<ResourceDecoder<T, R>> result = new ArrayList<ResourceDecoder<T, R>>();
        for (Entry<T, T> entry : this.decoders) {
            if (!entry.handles(dataClass, resourceClass)) continue;
            result.add(entry.decoder);
        }
        return result;
    }

    public synchronized <T, R> List<Class<R>> getResourceClasses(Class<T> dataClass, Class<R> resourceClass) {
        ArrayList<Class<R>> result = new ArrayList<Class<R>>();
        for (Entry<T, T> entry : this.decoders) {
            if (!entry.handles(dataClass, resourceClass)) continue;
            result.add(entry.resourceClass);
        }
        return result;
    }

    public synchronized <T, R> void append(ResourceDecoder<T, R> decoder, Class<T> dataClass, Class<R> resourceClass) {
        this.decoders.add(new Entry<T, R>(dataClass, resourceClass, decoder));
    }

    public synchronized <T, R> void prepend(ResourceDecoder<T, R> decoder, Class<T> dataClass, Class<R> resourceClass) {
        this.decoders.add(0, new Entry<T, R>(dataClass, resourceClass, decoder));
    }

    private static class Entry<T, R> {
        private final Class<T> dataClass;
        final Class<R> resourceClass;
        final ResourceDecoder<T, R> decoder;

        public Entry(Class<T> dataClass, Class<R> resourceClass, ResourceDecoder<T, R> decoder) {
            this.dataClass = dataClass;
            this.resourceClass = resourceClass;
            this.decoder = decoder;
        }

        public boolean handles(Class<?> dataClass, Class<?> resourceClass) {
            return this.dataClass.isAssignableFrom(dataClass) && resourceClass.isAssignableFrom(this.resourceClass);
        }
    }
}

