/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.os.Bundle;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.push.AutoValue_PushPayload;

public abstract class PushPayload {
    private static final String PUSH_ONLY = "push_only";
    private static final String MESSAGE_TYPE = "message";

    public static PushPayload create(@Nullable Bundle extras) {
        if (extras == null) {
            return PushPayload.create(Bundle.EMPTY);
        }
        int priority = extras.getInt("intercom_priority_type", 1);
        return new AutoValue_PushPayload(PushPayload.stringOrEmpty(extras, "conversation_id"), PushPayload.stringOrEmpty(extras, MESSAGE_TYPE), PushPayload.stringOrEmpty(extras, "body"), PushPayload.stringOrEmpty(extras, "author_name"), PushPayload.stringOrEmpty(extras, "image_url"), PushPayload.stringOrEmpty(extras, "app_name"), PushPayload.stringOrEmpty(extras, "receiver"), PushPayload.stringOrEmpty(extras, "conversation_part_type"), PushPayload.stringOrEmpty(extras, "intercom_push_type"), PushPayload.stringOrEmpty(extras, "uri"), PushPayload.stringOrEmpty(extras, "push_only_conv_id"), PushPayload.stringOrEmpty(extras, "title"), priority);
    }

    public abstract String getConversationId();

    public abstract String getMessage();

    public abstract String getBody();

    public abstract String getAuthorName();

    public abstract String getImageUrl();

    public abstract String getAppName();

    public abstract String getReceiver();

    public abstract String getConversationPartType();

    public abstract String getIntercomPushType();

    public abstract String getUri();

    public abstract String getPushOnlyConversationId();

    public abstract String getTitle();

    public abstract int getPriority();

    String messageOrBody() {
        return this.getMessage().isEmpty() ? this.getBody() : this.getMessage();
    }

    boolean isIntercomPush() {
        return !this.getIntercomPushType().isEmpty() && "intercom_sdk".equals(this.getReceiver());
    }

    boolean isPushOnly() {
        return PUSH_ONLY.equals(this.getIntercomPushType());
    }

    boolean isFirstPart() {
        return MESSAGE_TYPE.equals(this.getConversationPartType());
    }

    private static String stringOrEmpty(Bundle extras, String key) {
        return extras.getString(key, "");
    }
}

