/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.GlideContext;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.intercom.com.bumptech.glide.request.FutureTarget;
import io.intercom.com.bumptech.glide.request.Request;
import io.intercom.com.bumptech.glide.request.RequestCoordinator;
import io.intercom.com.bumptech.glide.request.RequestFutureTarget;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.SingleRequest;
import io.intercom.com.bumptech.glide.request.ThumbnailRequestCoordinator;
import io.intercom.com.bumptech.glide.request.target.PreloadTarget;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.signature.ApplicationVersionSignature;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import io.intercom.com.bumptech.glide.util.Preconditions;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.File;
import java.net.URL;
import java.util.UUID;

public class RequestBuilder<TranscodeType>
implements Cloneable {
    protected static final RequestOptions DOWNLOAD_ONLY_OPTIONS = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.DATA).priority(Priority.LOW).skipMemoryCache(true);
    private final GlideContext context;
    private final RequestManager requestManager;
    private final Class<TranscodeType> transcodeClass;
    private final RequestOptions defaultRequestOptions;
    private final Glide glide;
    @NonNull
    protected RequestOptions requestOptions;
    @NonNull
    private TransitionOptions<?, ? super TranscodeType> transitionOptions;
    @Nullable
    private Object model;
    @Nullable
    private RequestListener<TranscodeType> requestListener;
    @Nullable
    private RequestBuilder<TranscodeType> thumbnailBuilder;
    @Nullable
    private Float thumbSizeMultiplier;
    private boolean isDefaultTransitionOptionsSet = true;
    private boolean isModelSet;
    private boolean isThumbnailBuilt;

    protected RequestBuilder(Glide glide, RequestManager requestManager, Class<TranscodeType> transcodeClass) {
        this.glide = glide;
        this.requestManager = requestManager;
        this.context = glide.getGlideContext();
        this.transcodeClass = transcodeClass;
        this.defaultRequestOptions = requestManager.getDefaultRequestOptions();
        this.transitionOptions = requestManager.getDefaultTransitionOptions(transcodeClass);
        this.requestOptions = this.defaultRequestOptions;
    }

    protected RequestBuilder(Class<TranscodeType> transcodeClass, RequestBuilder<?> other) {
        this(other.glide, other.requestManager, transcodeClass);
        this.model = other.model;
        this.isModelSet = other.isModelSet;
        this.requestOptions = other.requestOptions;
    }

    public RequestBuilder<TranscodeType> apply(@NonNull RequestOptions requestOptions) {
        Preconditions.checkNotNull(requestOptions);
        this.requestOptions = this.getMutableOptions().apply(requestOptions);
        return this;
    }

    protected RequestOptions getMutableOptions() {
        return this.defaultRequestOptions == this.requestOptions ? this.requestOptions.clone() : this.requestOptions;
    }

    public RequestBuilder<TranscodeType> transition(@NonNull TransitionOptions<?, ? super TranscodeType> transitionOptions) {
        this.transitionOptions = Preconditions.checkNotNull(transitionOptions);
        this.isDefaultTransitionOptionsSet = false;
        return this;
    }

    public RequestBuilder<TranscodeType> listener(@Nullable RequestListener<TranscodeType> requestListener) {
        this.requestListener = requestListener;
        return this;
    }

    public RequestBuilder<TranscodeType> thumbnail(@Nullable RequestBuilder<TranscodeType> thumbnailRequest) {
        this.thumbnailBuilder = thumbnailRequest;
        return this;
    }

    public RequestBuilder<TranscodeType> thumbnail(float sizeMultiplier) {
        if (sizeMultiplier < 0.0f || sizeMultiplier > 1.0f) {
            throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
        }
        this.thumbSizeMultiplier = Float.valueOf(sizeMultiplier);
        return this;
    }

    public RequestBuilder<TranscodeType> load(@Nullable Object model) {
        return this.loadGeneric(model);
    }

    private RequestBuilder<TranscodeType> loadGeneric(@Nullable Object model) {
        this.model = model;
        this.isModelSet = true;
        return this;
    }

    public RequestBuilder<TranscodeType> load(@Nullable String string) {
        return this.loadGeneric(string);
    }

    public RequestBuilder<TranscodeType> load(@Nullable Uri uri) {
        return this.loadGeneric(uri);
    }

    public RequestBuilder<TranscodeType> load(@Nullable File file) {
        return this.loadGeneric(file);
    }

    public RequestBuilder<TranscodeType> load(@Nullable Integer resourceId) {
        return this.loadGeneric(resourceId).apply(RequestOptions.signatureOf(ApplicationVersionSignature.obtain((Context)this.context)));
    }

    @Deprecated
    public RequestBuilder<TranscodeType> load(@Nullable URL url) {
        return this.loadGeneric(url);
    }

    public RequestBuilder<TranscodeType> load(@Nullable byte[] model) {
        return this.loadGeneric(model).apply(RequestOptions.signatureOf(new ObjectKey(UUID.randomUUID().toString())).diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true));
    }

    public RequestBuilder<TranscodeType> clone() {
        try {
            RequestBuilder result = (RequestBuilder)super.clone();
            result.requestOptions = result.requestOptions.clone();
            result.transitionOptions = result.transitionOptions.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public <Y extends Target<TranscodeType>> Y into(@NonNull Y target) {
        Util.assertMainThread();
        Preconditions.checkNotNull(target);
        if (!this.isModelSet) {
            throw new IllegalArgumentException("You must call #load() before calling #into()");
        }
        this.requestOptions.lock();
        Request request = this.buildRequest(target);
        Request previous = target.getRequest();
        if (request.isEquivalentTo(previous) && (Preconditions.checkNotNull(previous).isComplete() || Preconditions.checkNotNull(previous).isRunning())) {
            request.recycle();
            if (!Preconditions.checkNotNull(previous).isRunning()) {
                previous.begin();
            }
            return target;
        }
        this.requestManager.clear(target);
        target.setRequest(request);
        this.requestManager.track(target, request);
        return target;
    }

    public Target<TranscodeType> into(ImageView view) {
        Util.assertMainThread();
        Preconditions.checkNotNull(view);
        if (!this.requestOptions.isTransformationSet() && this.requestOptions.isTransformationAllowed() && view.getScaleType() != null) {
            if (this.requestOptions.isLocked()) {
                this.requestOptions = this.requestOptions.clone();
            }
            switch (view.getScaleType()) {
                case CENTER_CROP: {
                    this.requestOptions.optionalCenterCrop();
                    break;
                }
                case CENTER_INSIDE: {
                    this.requestOptions.optionalCenterInside();
                    break;
                }
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: {
                    this.requestOptions.optionalFitCenter();
                    break;
                }
                case FIT_XY: {
                    this.requestOptions.optionalCenterInside();
                    break;
                }
            }
        }
        return this.into(this.context.buildImageViewTarget(view, this.transcodeClass));
    }

    @Deprecated
    public FutureTarget<TranscodeType> into(int width, int height) {
        return this.submit(width, height);
    }

    public FutureTarget<TranscodeType> submit() {
        return this.submit(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public FutureTarget<TranscodeType> submit(int width, int height) {
        final RequestFutureTarget target = new RequestFutureTarget(this.context.getMainHandler(), width, height);
        if (Util.isOnBackgroundThread()) {
            this.context.getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    if (!target.isCancelled()) {
                        RequestBuilder.this.into(target);
                    }
                }
            });
        } else {
            this.into(target);
        }
        return target;
    }

    public Target<TranscodeType> preload(int width, int height) {
        PreloadTarget target = PreloadTarget.obtain(this.requestManager, width, height);
        return this.into(target);
    }

    public Target<TranscodeType> preload() {
        return this.preload(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Deprecated
    public <Y extends Target<File>> Y downloadOnly(Y target) {
        return this.getDownloadOnlyRequest().into(target);
    }

    @Deprecated
    public FutureTarget<File> downloadOnly(int width, int height) {
        return this.getDownloadOnlyRequest().submit(width, height);
    }

    protected RequestBuilder<File> getDownloadOnlyRequest() {
        return new RequestBuilder<File>(File.class, this).apply(DOWNLOAD_ONLY_OPTIONS);
    }

    private Priority getThumbnailPriority(Priority current) {
        switch (current) {
            case LOW: {
                return Priority.NORMAL;
            }
            case NORMAL: {
                return Priority.HIGH;
            }
            case HIGH: 
            case IMMEDIATE: {
                return Priority.IMMEDIATE;
            }
        }
        throw new IllegalArgumentException("unknown priority: " + (Object)((Object)this.requestOptions.getPriority()));
    }

    private Request buildRequest(Target<TranscodeType> target) {
        return this.buildRequestRecursive(target, null, this.transitionOptions, this.requestOptions.getPriority(), this.requestOptions.getOverrideWidth(), this.requestOptions.getOverrideHeight());
    }

    private Request buildRequestRecursive(Target<TranscodeType> target, @Nullable ThumbnailRequestCoordinator parentCoordinator, TransitionOptions<?, ? super TranscodeType> transitionOptions, Priority priority, int overrideWidth, int overrideHeight) {
        if (this.thumbnailBuilder != null) {
            if (this.isThumbnailBuilt) {
                throw new IllegalStateException("You cannot use a request as both the main request and a thumbnail, consider using clone() on the request(s) passed to thumbnail()");
            }
            TransitionOptions<?, ? super TranscodeType> thumbTransitionOptions = this.thumbnailBuilder.transitionOptions;
            if (this.thumbnailBuilder.isDefaultTransitionOptionsSet) {
                thumbTransitionOptions = transitionOptions;
            }
            Priority thumbPriority = this.thumbnailBuilder.requestOptions.isPrioritySet() ? this.thumbnailBuilder.requestOptions.getPriority() : this.getThumbnailPriority(priority);
            int thumbOverrideWidth = this.thumbnailBuilder.requestOptions.getOverrideWidth();
            int thumbOverrideHeight = this.thumbnailBuilder.requestOptions.getOverrideHeight();
            if (Util.isValidDimensions(overrideWidth, overrideHeight) && !this.thumbnailBuilder.requestOptions.isValidOverride()) {
                thumbOverrideWidth = this.requestOptions.getOverrideWidth();
                thumbOverrideHeight = this.requestOptions.getOverrideHeight();
            }
            ThumbnailRequestCoordinator coordinator = new ThumbnailRequestCoordinator(parentCoordinator);
            Request fullRequest = this.obtainRequest(target, this.requestOptions, coordinator, transitionOptions, priority, overrideWidth, overrideHeight);
            this.isThumbnailBuilt = true;
            Request thumbRequest = super.buildRequestRecursive(target, coordinator, thumbTransitionOptions, thumbPriority, thumbOverrideWidth, thumbOverrideHeight);
            this.isThumbnailBuilt = false;
            coordinator.setRequests(fullRequest, thumbRequest);
            return coordinator;
        }
        if (this.thumbSizeMultiplier != null) {
            ThumbnailRequestCoordinator coordinator = new ThumbnailRequestCoordinator(parentCoordinator);
            Request fullRequest = this.obtainRequest(target, this.requestOptions, coordinator, transitionOptions, priority, overrideWidth, overrideHeight);
            RequestOptions thumbnailOptions = this.requestOptions.clone().sizeMultiplier(this.thumbSizeMultiplier.floatValue());
            Request thumbnailRequest = this.obtainRequest(target, thumbnailOptions, coordinator, transitionOptions, this.getThumbnailPriority(priority), overrideWidth, overrideHeight);
            coordinator.setRequests(fullRequest, thumbnailRequest);
            return coordinator;
        }
        return this.obtainRequest(target, this.requestOptions, parentCoordinator, transitionOptions, priority, overrideWidth, overrideHeight);
    }

    private Request obtainRequest(Target<TranscodeType> target, RequestOptions requestOptions, RequestCoordinator requestCoordinator, TransitionOptions<?, ? super TranscodeType> transitionOptions, Priority priority, int overrideWidth, int overrideHeight) {
        requestOptions.lock();
        return SingleRequest.obtain(this.context, this.model, this.transcodeClass, requestOptions, overrideWidth, overrideHeight, priority, target, this.requestListener, requestCoordinator, this.context.getEngine(), transitionOptions.getTransitionFactory());
    }
}

