/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.errorreporting;

import android.content.Context;
import android.os.AsyncTask;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.errorreporting.ErrorReport;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.IoUtils;
import io.intercom.com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.concurrent.RejectedExecutionException;

class ErrorReportStore {
    private static final String REPORT_FILE_PATH = "/intercom-error.json";
    private static final Twig TWIG = LumberMill.getLogger();
    private final File reportFile;
    private final Gson gson;

    public static ErrorReportStore create(Context appContext, Gson gson) {
        File reportFile = new File(appContext.getCacheDir().getAbsolutePath() + REPORT_FILE_PATH);
        return new ErrorReportStore(reportFile, gson);
    }

    ErrorReportStore(File reportFile, Gson gson) {
        this.reportFile = reportFile;
        this.gson = gson;
    }

    void sendSavedReport(final Provider<Api> apiProvider) {
        try {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ErrorReportStore.this.reportFile.exists()) {
                        ErrorReportStore.this.readAndSendReport((Api)apiProvider.get());
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            TWIG.internal("Couldn't queue up sending of event: " + e);
        }
    }

    private void readAndSendReport(Api api) {
        try {
            FileReader fileReader = new FileReader(this.reportFile);
            api.sendErrorReport((ErrorReport)this.gson.fromJson((Reader)fileReader, ErrorReport.class));
            IoUtils.safelyDelete(this.reportFile);
        }
        catch (Exception e) {
            IoUtils.safelyDelete(this.reportFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToDisk(ErrorReport report) {
        FileWriter writer;
        block5: {
            writer = null;
            if (!this.reportFile.exists() || this.reportFile.delete()) break block5;
            IoUtils.closeQuietly(writer);
            return;
        }
        try {
            writer = new FileWriter(this.reportFile);
            this.gson.toJson((Object)report, (Appendable)writer);
        }
        catch (Exception e) {
            try {
                TWIG.internal("Couldn't save report to disk: " + e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(writer);
                throw throwable;
            }
            IoUtils.closeQuietly(writer);
        }
        IoUtils.closeQuietly(writer);
    }
}

