/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.support.annotation.NonNull;
import android.util.Base64;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class DataUrlLoader<Data>
implements ModelLoader<String, Data> {
    private static final String DATA_SCHEME_IMAGE = "data:image";
    private static final String BASE64_TAG = ";base64";
    private final DataDecoder<Data> dataDecoder;

    public DataUrlLoader(DataDecoder<Data> dataDecoder) {
        this.dataDecoder = dataDecoder;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(String model, int width, int height, Options options) {
        return new ModelLoader.LoadData<Data>(new ObjectKey(model), new DataUriFetcher<Data>(model, this.dataDecoder));
    }

    @Override
    public boolean handles(String url) {
        return url.startsWith(DATA_SCHEME_IMAGE);
    }

    public static final class StreamFactory
    implements ModelLoaderFactory<String, InputStream> {
        private final DataDecoder<InputStream> opener = new DataDecoder<InputStream>(){

            @Override
            public InputStream decode(String url) {
                if (!url.startsWith(DataUrlLoader.DATA_SCHEME_IMAGE)) {
                    throw new IllegalArgumentException("Not a valid image data URL.");
                }
                int commaIndex = url.indexOf(44);
                if (commaIndex == -1) {
                    throw new IllegalArgumentException("Missing comma in data URL.");
                }
                String beforeComma = url.substring(0, commaIndex);
                if (!beforeComma.endsWith(DataUrlLoader.BASE64_TAG)) {
                    throw new IllegalArgumentException("Not a base64 image data URL.");
                }
                String afterComma = url.substring(commaIndex + 1);
                byte[] bytes = Base64.decode((String)afterComma, (int)0);
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public void close(InputStream inputStream) throws IOException {
                inputStream.close();
            }

            @Override
            public Class<InputStream> getDataClass() {
                return InputStream.class;
            }
        };

        @Override
        public final ModelLoader<String, InputStream> build(MultiModelLoaderFactory multiFactory) {
            return new DataUrlLoader<InputStream>(this.opener);
        }

        @Override
        public final void teardown() {
        }
    }

    private static final class DataUriFetcher<Data>
    implements DataFetcher<Data> {
        private final String dataUri;
        private final DataDecoder<Data> reader;
        private Data data;

        public DataUriFetcher(String dataUri, DataDecoder<Data> reader) {
            this.dataUri = dataUri;
            this.reader = reader;
        }

        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super Data> callback) {
            try {
                this.data = this.reader.decode(this.dataUri);
                callback.onDataReady(this.data);
            }
            catch (IllegalArgumentException e) {
                callback.onLoadFailed(e);
            }
        }

        @Override
        public void cleanup() {
            try {
                this.reader.close(this.data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<Data> getDataClass() {
            return this.reader.getDataClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }

    public static interface DataDecoder<Data> {
        public Data decode(String var1) throws IllegalArgumentException;

        public void close(Data var1) throws IOException;

        public Class<Data> getDataClass();
    }
}

