/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;

public class ScreenshotContentObserver
extends ContentObserver {
    private static final String EXTERNAL_CONTENT_URI_STRING = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString();
    private static final String[] PROJECTION = new String[]{"_display_name", "_data", "date_added"};
    private static final String SORT_ORDER = "date_added DESC";
    private static final long DEFAULT_DETECT_WINDOW_SECONDS = 5L;
    private static final String ROOT_FOLDER_URI_STRING = "content://media/external";
    private final Store<State> store;
    private final ContentResolver contentResolver;
    private final Twig twig = LumberMill.getLogger();
    private long lastScreenshotTimestamp;

    public ScreenshotContentObserver(Store<State> store, ContentResolver contentResolver) {
        super(null);
        this.store = store;
        this.contentResolver = contentResolver;
    }

    public void onChange(boolean selfChange, Uri uri) {
        String uriString = uri.toString();
        if (ROOT_FOLDER_URI_STRING.equals(uriString)) {
            this.queryContentForUri(MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        } else if (uriString.startsWith(EXTERNAL_CONTENT_URI_STRING)) {
            this.queryContentForUri(uri);
        }
        super.onChange(selfChange, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryContentForUri(Uri uri) {
        try (Cursor cursor = null;){
            cursor = this.contentResolver.query(uri, PROJECTION, null, null, SORT_ORDER);
            Uri latestScreenshot = this.getLatestScreenshot(cursor);
            if (latestScreenshot == Uri.EMPTY) {
                this.store.dispatch(Actions.screenshotDeleted());
            } else {
                this.store.dispatch(Actions.screenshotTaken(latestScreenshot));
            }
        }
    }

    private Uri getLatestScreenshot(@Nullable Cursor cursor) {
        if (cursor != null && cursor.moveToFirst()) {
            String path = cursor.getString(cursor.getColumnIndex("_data"));
            long dateAdded = cursor.getLong(cursor.getColumnIndex("date_added"));
            if (this.isInScreenshotFolder(path) && this.isRecentEnough(dateAdded)) {
                this.lastScreenshotTimestamp = dateAdded;
                return Uri.parse((String)path);
            }
        }
        return Uri.EMPTY;
    }

    private boolean isInScreenshotFolder(String path) {
        return path.contains("Screenshot");
    }

    private boolean isRecentEnough(long dateAdded) {
        long currentTime = TimeProvider.SYSTEM.currentTimeMillis() / 1000L;
        if (dateAdded < this.lastScreenshotTimestamp) {
            return false;
        }
        return Math.abs(currentTime - dateAdded) <= 5L;
    }
}

