/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.signature;

import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class MediaStoreSignature
implements Key {
    private final String mimeType;
    private final long dateModified;
    private final int orientation;

    public MediaStoreSignature(String mimeType, long dateModified, int orientation) {
        this.mimeType = mimeType;
        this.dateModified = dateModified;
        this.orientation = orientation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaStoreSignature that = (MediaStoreSignature)o;
        if (this.dateModified != that.dateModified) {
            return false;
        }
        if (this.orientation != that.orientation) {
            return false;
        }
        return Util.bothNullOrEqual(this.mimeType, that.mimeType);
    }

    @Override
    public int hashCode() {
        int result = this.mimeType != null ? this.mimeType.hashCode() : 0;
        result = 31 * result + (int)(this.dateModified ^ this.dateModified >>> 32);
        result = 31 * result + this.orientation;
        return result;
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) {
        byte[] data = ByteBuffer.allocate(12).putLong(this.dateModified).putInt(this.orientation).array();
        messageDigest.update(data);
        messageDigest.update(this.mimeType.getBytes(CHARSET));
    }
}

