/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine;

import android.support.v4.util.Pools;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.data.DataRewinder;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DecodePath<DataType, ResourceType, Transcode> {
    private static final String TAG = "DecodePath";
    private final Class<DataType> dataClass;
    private final List<? extends ResourceDecoder<DataType, ResourceType>> decoders;
    private final ResourceTranscoder<ResourceType, Transcode> transcoder;
    private final Pools.Pool<List<Exception>> listPool;
    private final String failureMessage;

    public DecodePath(Class<DataType> dataClass, Class<ResourceType> resourceClass, Class<Transcode> transcodeClass, List<? extends ResourceDecoder<DataType, ResourceType>> decoders, ResourceTranscoder<ResourceType, Transcode> transcoder, Pools.Pool<List<Exception>> listPool) {
        this.dataClass = dataClass;
        this.decoders = decoders;
        this.transcoder = transcoder;
        this.listPool = listPool;
        this.failureMessage = "Failed DecodePath{" + dataClass.getSimpleName() + "->" + resourceClass.getSimpleName() + "->" + transcodeClass.getSimpleName() + "}";
    }

    public Resource<Transcode> decode(DataRewinder<DataType> rewinder, int width, int height, Options options, DecodeCallback<ResourceType> callback) throws GlideException {
        Resource<ResourceType> decoded = this.decodeResource(rewinder, width, height, options);
        Resource<ResourceType> transformed = callback.onResourceDecoded(decoded);
        return this.transcoder.transcode(transformed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource<ResourceType> decodeResource(DataRewinder<DataType> rewinder, int width, int height, Options options) throws GlideException {
        List exceptions = (List)this.listPool.acquire();
        try {
            Resource<ResourceType> resource = this.decodeResourceWithList(rewinder, width, height, options, exceptions);
            return resource;
        }
        finally {
            this.listPool.release((Object)exceptions);
        }
    }

    private Resource<ResourceType> decodeResourceWithList(DataRewinder<DataType> rewinder, int width, int height, Options options, List<Exception> exceptions) throws GlideException {
        Resource<ResourceType> result = null;
        int size = this.decoders.size();
        for (int i = 0; i < size; ++i) {
            ResourceDecoder<DataType, ResourceType> decoder = this.decoders.get(i);
            try {
                DataType data = rewinder.rewindAndGet();
                if (decoder.handles(data, options)) {
                    data = rewinder.rewindAndGet();
                    result = decoder.decode(data, width, height, options);
                }
            }
            catch (IOException e) {
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)("Failed to decode data for " + decoder), (Throwable)e);
                }
                exceptions.add(e);
            }
            if (result != null) break;
        }
        if (result == null) {
            throw new GlideException(this.failureMessage, new ArrayList<Exception>(exceptions));
        }
        return result;
    }

    public String toString() {
        return "DecodePath{ dataClass=" + this.dataClass + ", decoders=" + this.decoders + ", transcoder=" + this.transcoder + '}';
    }

    static interface DecodeCallback<ResourceType> {
        public Resource<ResourceType> onResourceDecoded(Resource<ResourceType> var1);
    }
}

