/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.database.ContentObserver;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.support.v7.appcompat.R;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.overlay.ScreenshotContentObserver;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ActivityUtils;
import io.intercom.android.sdk.utilities.StoreUtils;

public class ScreenshotMiddleware
implements Store.Middleware<State> {
    private final Provider<AppConfig> appConfigProvider;
    private final Context context;
    @Nullable
    private Runnable dialogDismiss;
    @Nullable
    private Store.Subscription observerSubscription;

    public ScreenshotMiddleware(Provider<AppConfig> appConfigProvider, Context context) {
        this.appConfigProvider = appConfigProvider;
        this.context = context;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        if (!this.appConfigProvider.get().hasFeature("screenshot-sharing")) {
            return;
        }
        switch (action.type()) {
            case APP_ENTERED_FOREGROUND: {
                this.startDetector(store);
                break;
            }
            case SCREENSHOT_TAKEN: {
                this.showShareDialog(store);
                break;
            }
            case SCREENSHOT_DELETED: {
                if (store.state().lastScreenshot() != Uri.EMPTY || this.dialogDismiss == null) break;
                this.dialogDismiss.run();
                break;
            }
            case APP_ENTERED_BACKGROUND: {
                StoreUtils.safeUnsubscribe(this.observerSubscription);
                break;
            }
        }
    }

    private void startDetector(Store<State> store) {
        StoreUtils.safeUnsubscribe(this.observerSubscription);
        final ContentResolver contentResolver = this.context.getContentResolver();
        final ScreenshotContentObserver observer = new ScreenshotContentObserver(store, contentResolver);
        contentResolver.registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, true, (ContentObserver)observer);
        this.observerSubscription = new Store.Subscription(){

            @Override
            public void unsubscribe() {
                contentResolver.unregisterContentObserver(observer);
            }
        };
    }

    private void showShareDialog(Store<State> store) {
        final Activity activity = store.select(Selectors.OVERLAY).resumedHostActivity();
        if (activity == null) {
            return;
        }
        final String appName = this.appConfigProvider.get().getName();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                final AlertDialog dialog = new AlertDialog.Builder((Context)activity, R.style.Theme_AppCompat_Light_Dialog_Alert).setTitle((CharSequence)"Share screenshot?").setMessage((CharSequence)("Edit and share this screenshot with " + appName + "?")).setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        if (ActivityUtils.isNotActive(activity)) {
                            return;
                        }
                        activity.startActivity(IntercomMessengerActivity.openComposer((Context)activity, ""));
                    }
                }).create();
                if (ScreenshotMiddleware.this.dialogDismiss != null) {
                    ScreenshotMiddleware.this.dialogDismiss.run();
                }
                ScreenshotMiddleware.this.dialogDismiss = new Runnable(){

                    @Override
                    public void run() {
                        dialog.dismiss();
                    }
                };
                dialog.show();
            }
        });
    }
}

