/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.ArrayMap;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.Blocks;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.LightboxOpeningImageClickListener;
import io.intercom.android.sdk.blocks.LinkOpeningButtonClickListener;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.function.TimestampAdder;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.ConversationPartAdapter;
import io.intercom.android.sdk.conversation.IntercomLinkPresenter;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.decoration.ConversationItemDecoration;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class NativeConversationContentPresenter
implements ConversationContentPresenter,
IntercomLinkPresenter.IntercomLinkHost {
    private static final String IMAGE_MIME_TYPE = "image";
    private static final long PART_DISPLAY_DELIVERED_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    static final long TIMESTAMP_UPDATE_PERIOD = TimeUnit.MINUTES.toMillis(1L);
    private final Part loadingPart = new Part.Builder().withStyle("loading_layout_style").build();
    private final TimestampAdder timestampAdder = TimestampAdder.create();
    final List<Part> sendingParts = new ArrayList<Part>();
    private final Map<String, AdminIsTypingView> isTypingViews = new ArrayMap();
    private final ConversationContentPresenter.Host host;
    private final RecyclerView conversationList;
    private final ConversationPartAdapter adapter;
    private final LinearLayoutManager layoutManager;
    private final IntercomLinkPresenter intercomLinkPresenter;
    private final TextView pill;
    private final List<Part> parts;
    private final SoundPlayer soundPlayer;
    private final Blocks blocks;
    private final BlocksViewHolder blocksUserViewHolder;
    private final BlocksViewHolder blocksAnnouncementViewHolder;
    private final BlocksViewHolder blocksAdminViewHolder;
    private final BlocksViewHolder blocksLinkViewHolder;
    private final BlocksViewHolder blocksConversationRatingViewHolder;
    private final BlocksViewHolder blocksPreviewViewHolder;
    private final UploadingImageCache uploadingImageCache;
    private final Api api;
    private final UserIdentity userIdentity;
    private final OpsMetricTracker opsMetricTracker;
    private String conversationId;
    private Runnable replyDeliveredUpdater;
    private final Runnable timestampUpdater = new Runnable(){

        @Override
        public void run() {
            NativeConversationContentPresenter.this.adapter.notifyDataSetChanged();
            NativeConversationContentPresenter.this.conversationList.postDelayed((Runnable)this, TIMESTAMP_UPDATE_PERIOD);
        }
    };

    static NativeConversationContentPresenter create(ConversationContentPresenter.Host host, RecyclerView conversationList, ConversationPartAdapter adapter, IntercomLinkView intercomLinkView, Provider<AppConfig> appConfigProvider, Api api, List<Part> parts, String conversationId, TextView pill, SoundPlayer soundPlayer, Blocks blocks, UserIdentity userIdentity, OpsMetricTracker opsMetricTracker) {
        LinearLayoutManager layoutManager = new LinearLayoutManager(conversationList.getContext());
        IntercomLinkPresenter linkPresenter = new IntercomLinkPresenter(intercomLinkView, appConfigProvider, api, parts, conversationId);
        UploadingImageCache uploadingImageCache = new UploadingImageCache();
        ViewHolderGenerator generator = new ViewHolderGenerator(uploadingImageCache, api, appConfigProvider, conversationId, new LightboxOpeningImageClickListener(api), new LinkOpeningButtonClickListener(api));
        return new NativeConversationContentPresenter(host, conversationList, adapter, layoutManager, linkPresenter, pill, parts, soundPlayer, blocks, generator, userIdentity, api, opsMetricTracker, uploadingImageCache);
    }

    @VisibleForTesting
    NativeConversationContentPresenter(ConversationContentPresenter.Host host, RecyclerView conversationList, ConversationPartAdapter adapter, LinearLayoutManager layoutManager, IntercomLinkPresenter intercomLinkPresenter, TextView pill, List<Part> parts, SoundPlayer soundPlayer, Blocks blocks, ViewHolderGenerator generator, UserIdentity userIdentity, Api api, OpsMetricTracker opsMetricTracker, UploadingImageCache uploadingImageCache) {
        this.host = host;
        this.conversationList = conversationList;
        this.adapter = adapter;
        this.layoutManager = layoutManager;
        this.intercomLinkPresenter = intercomLinkPresenter;
        this.pill = pill;
        this.parts = parts;
        this.soundPlayer = soundPlayer;
        this.blocks = blocks;
        this.userIdentity = userIdentity;
        this.api = api;
        this.opsMetricTracker = opsMetricTracker;
        this.uploadingImageCache = uploadingImageCache;
        this.blocksUserViewHolder = generator.getUserHolder();
        this.blocksAnnouncementViewHolder = generator.getContainerCardHolder();
        this.blocksAdminViewHolder = generator.getAdminHolder();
        this.blocksLinkViewHolder = generator.getLinkHolder();
        this.blocksConversationRatingViewHolder = generator.getConversationRatingHolder();
        this.blocksPreviewViewHolder = generator.getPreviewHolder();
    }

    @Override
    public void setup() {
        this.opsMetricTracker.trackEvent("finish", "time-to-process-action-load-conversation-ms");
        this.conversationList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.conversationList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.conversationList.addItemDecoration((RecyclerView.ItemDecoration)new ConversationItemDecoration(this.conversationList.getContext(), this.parts));
        ((SimpleItemAnimator)this.conversationList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.conversationList.setNestedScrollingEnabled(true);
        this.conversationList.setVisibility(0);
        this.conversationList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                if (newState == 0 && NativeConversationContentPresenter.this.isAtBottom()) {
                    NativeConversationContentPresenter.this.pill.setVisibility(8);
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                NativeConversationContentPresenter.this.intercomLinkPresenter.updateIntercomLink(NativeConversationContentPresenter.this);
            }
        });
        this.intercomLinkPresenter.setup(this);
        this.pill.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NativeConversationContentPresenter.this.pill.setVisibility(8);
                NativeConversationContentPresenter.this.smoothScrollToBottom();
            }
        });
    }

    @Override
    public void smoothScrollToTop() {
        this.conversationList.smoothScrollToPosition(0);
    }

    private void smoothScrollToBottom() {
        this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
    }

    @Override
    public void scrollToTop() {
        this.conversationList.scrollToPosition(0);
    }

    @Override
    public void scrollToBottom() {
        this.conversationList.scrollToPosition(this.adapter.getCount() - 1);
    }

    @Override
    public void addBottomPadding(int extraBottomPadding) {
        this.conversationList.setPadding(this.conversationList.getPaddingLeft(), this.conversationList.getPaddingTop(), this.conversationList.getPaddingRight(), this.conversationList.getPaddingBottom() + extraBottomPadding);
    }

    @Override
    public boolean isAtBottom() {
        return this.layoutManager.findLastCompletelyVisibleItemPosition() >= this.layoutManager.getChildCount() - 1;
    }

    @Override
    public void onProfileScrolled() {
        int lastViewIndex = this.adapter.getCount() - 1;
        View lastChildView = lastViewIndex > 0 ? this.conversationList.getChildAt(lastViewIndex) : null;
        this.intercomLinkPresenter.onProfileScrolled(lastChildView);
    }

    @Override
    public void onGlobalLayout() {
        this.intercomLinkPresenter.updateIntercomLink(this);
    }

    @Override
    public void onNewPartReceived() {
        for (AdminIsTypingView isTypingView : this.isTypingViews.values()) {
            if (isTypingView == null) continue;
            isTypingView.cancelTypingAnimation();
        }
        if (this.isAtBottom()) {
            this.smoothScrollToBottom();
        } else if (this.parts.size() > 0 && this.parts.get(this.parts.size() - 1).isAdmin()) {
            this.pill.setVisibility(0);
        }
    }

    @Override
    public void showErrorView() {
        this.hideLoadingIndicator();
        this.pill.setVisibility(8);
        this.conversationList.setVisibility(8);
    }

    @Override
    public void showLoadingView() {
        this.showLoadingIndicator();
        this.pill.setVisibility(8);
        this.conversationList.setVisibility(0);
    }

    @Override
    public void showContentView() {
        this.hideLoadingIndicator();
        this.pill.setVisibility(8);
        this.conversationList.setVisibility(0);
    }

    private void showLoadingIndicator() {
        this.parts.add(0, this.loadingPart);
        this.adapter.notifyItemInserted(0);
    }

    private void hideLoadingIndicator() {
        int index = this.parts.indexOf(this.loadingPart);
        if (index >= 0) {
            this.parts.remove(index);
            this.adapter.notifyItemRemoved(index);
        }
    }

    private int positionOfPart(int position, String partId) {
        if (position >= 0 && position < this.parts.size()) {
            Part sendingPart = this.parts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            for (int i = this.parts.size() - 1; i >= 0; --i) {
                if (!this.parts.get(i).getId().equals(partId)) continue;
                return i;
            }
        }
        return -1;
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = this.parts.get(partPosition);
            View partView = this.adapter.getViewForPart(failedPart).getChildAt(0);
            if (partView instanceof UploadProgressListener) {
                UploadProgressListener listener = (UploadProgressListener)partView;
                listener.uploadStopped();
            }
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.soundPlayer.playReplyFailedSound();
    }

    private void addViewForPart(Part part) {
        Participant author;
        List<Block> blockParts = part.getBlocks();
        if (!part.getAttachments().isEmpty()) {
            ArrayList<BlockAttachment> blockAttachments = new ArrayList<BlockAttachment>();
            for (Attachments attachment : part.getAttachments()) {
                blockAttachments.add(new BlockAttachment.Builder().withName(attachment.getName()).withUrl(attachment.getUrl()).withContentType(attachment.getContentType()).build());
            }
            blockParts.add(new Block.Builder().withType(BlockType.ATTACHMENTLIST.name()).withAttachments(blockAttachments).build());
        }
        if ((author = part.getParticipant()).isUserWithId(this.userIdentity.getIntercomId())) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
        } else if ("post".equals(part.getMessageStyle()) || "note".equals(part.getMessageStyle())) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        } else if (part.isLinkCard()) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksLinkViewHolder));
        } else if (part.isRatingCard()) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksConversationRatingViewHolder));
        } else {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
        }
    }

    private void displaySendingPart(Part part) {
        this.soundPlayer.playReplySentSound();
        this.parts.add(part);
        this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(part.getBlocks(), this.blocksPreviewViewHolder));
        this.adapter.notifyDataSetChanged();
        this.smoothScrollToBottom();
    }

    @Override
    public synchronized void onAdminStartedTyping(AdminIsTypingEvent event) {
        final String adminId = event.getAdminId();
        if (this.isTypingViews.containsKey(adminId)) {
            this.isTypingViews.get(adminId).renewTypingAnimation();
            return;
        }
        final Part isTypingPart = new Part.Builder().withParticipantIsAdmin(true).withStyle("admin_is_typing_style").build();
        Participant participant = this.host.getConversation().getParticipant(adminId);
        if (participant == Participant.NULL) {
            participant = Participant.create(adminId, event.getAdminName(), "admin", "", Avatar.create(event.getAdminAvatarUrl(), ""));
        }
        isTypingPart.setParticipant(participant);
        isTypingPart.setEntranceAnimation(true);
        boolean wasAtBottom = this.isAtBottom();
        this.parts.add(isTypingPart);
        Context context = this.conversationList.getContext();
        LinearLayout container = (LinearLayout)View.inflate((Context)context, (int)R.layout.intercom_blocks_admin_layout, null);
        AdminIsTypingView view = new AdminIsTypingView(context);
        view.setListener(new AdminIsTypingView.Listener(){

            @Override
            public void onAdminTypingAnimationEnded(AdminIsTypingView view) {
                NativeConversationContentPresenter.this.onAdminStoppedTyping(adminId, isTypingPart.getId());
            }
        });
        container.addView((View)view);
        this.isTypingViews.put(adminId, view);
        this.adapter.setViewForPart(isTypingPart, (ViewGroup)container);
        this.adapter.notifyDataSetChanged();
        if (wasAtBottom) {
            this.smoothScrollToBottom();
        }
    }

    @Override
    public void onNewCommentEventReceived(NewCommentEvent event) {
    }

    void onAdminStoppedTyping(String adminId, String partId) {
        this.isTypingViews.remove(adminId);
        int position = this.positionOfPart(this.parts.size() - 1, partId);
        if (position >= 0) {
            this.parts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void fetchConversation(final String conversationId) {
        if (!conversationId.isEmpty()) {
            this.opsMetricTracker.trackEvent("start", "time-to-complete-request-load-conversation-ms");
            this.conversationId = conversationId;
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    NativeConversationContentPresenter.this.api.getConversation(conversationId);
                }
            });
        }
    }

    @Override
    public void onPartClicked(Part part) {
        if (part.getMessageState() == Part.MessageState.FAILED) {
            this.showRetryDialog(part);
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            this.retryFailedUpload(part);
        }
    }

    private void retryFailedUpload(Part part) {
        UploadProgressListener listener;
        int position = this.positionOfPart(this.parts.size() - 1, part.getId());
        if (position >= 0) {
            listener = (UploadProgressListener)this.adapter.getViewForPart(this.parts.get(position)).getChildAt(0);
            listener.uploadStarted();
        } else {
            listener = new UploadProgressListener(){

                @Override
                public void uploadStarted() {
                }

                @Override
                public void uploadNotice(byte percentUploaded) {
                }

                @Override
                public void uploadStopped() {
                }
            };
        }
        part.setMessageState(Part.MessageState.SENDING);
        this.parts.remove(this.parts.indexOf(part));
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        this.api.uploadFile(part.getUpload(), position, part.getId(), this.uploadingImageCache, listener);
    }

    private void showRetryDialog(final Part part) {
        new AlertDialog.Builder(this.conversationList.getContext()).setTitle(R.string.intercom_inbox_error_state_title).setMessage(R.string.intercom_failed_delivery).setPositiveButton(R.string.intercom_retry, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                NativeConversationContentPresenter.this.retryTapped(part);
            }
        }).show();
    }

    void retryTapped(Part part) {
        part.setMessageState(Part.MessageState.SENDING);
        this.parts.remove(part);
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        List<Block> partBlocks = part.getBlocks();
        int size = partBlocks.size();
        ArrayList<Block.Builder> blockBuilders = new ArrayList<Block.Builder>(partBlocks.size());
        for (int i = 0; i < size; ++i) {
            blockBuilders.add(partBlocks.get(i).toBuilder());
        }
        this.sendPart(blockBuilders);
    }

    private Part addSendingPart(List<Block.Builder> blocks) {
        Part part = this.createSendingPart(blocks);
        this.sendingParts.add(part);
        this.displaySendingPart(part);
        return part;
    }

    private Part createSendingPart(List<Block.Builder> blocks) {
        Part part = new Part.Builder().withCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis())).withStyle("chat").withBlocks(blocks).build();
        part.setMessageState(Part.MessageState.SENDING);
        part.setParticipant(this.getUserParticipant());
        part.setEntranceAnimation(true);
        return part;
    }

    Participant getUserParticipant() {
        String intercomId = this.userIdentity.getIntercomId();
        Participant user = this.host.getConversation().getParticipant(intercomId);
        if (user == Participant.NULL) {
            return new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    @Override
    public void sendPart(List<Block.Builder> blockBuilders) {
        this.opsMetricTracker.trackEvent("finish", "time-to-process-action-send-part-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-complete-request-send-part-ms");
        Part part = this.addSendingPart(blockBuilders);
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.api.startNewConversation(blockBuilders, this.parts.size() - 1, part.getId(), false);
        } else {
            this.api.replyToConversation(this.conversationId, blockBuilders, this.parts.size() - 1, part.getId(), false, false);
        }
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        int partPosition = this.positionOfPart(event.getTempPartPosition(), event.getTempPartId());
        if (partPosition < 0) {
            return;
        }
        Part part = this.parts.get(partPosition);
        if (part.getBlocks().isEmpty()) {
            return;
        }
        List<Block.Builder> blocks = this.createBlocksForUpload(event, part.getBlocks().get(0));
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.api.startNewConversation(blocks, this.parts.size() - 1, event.getTempPartId(), event.isAnnotatedImage());
        } else {
            this.api.replyToConversation(this.conversationId, blocks, partPosition, part.getId(), true, event.isAnnotatedImage());
        }
    }

    private List<Block.Builder> createBlocksForUpload(UploadEvent event, Block localFileBlock) {
        if (event.getUpload().getContentType().contains(IMAGE_MIME_TYPE)) {
            return Collections.singletonList(localFileBlock.toBuilder().withType(BlockType.IMAGE.getSerializedName()).withUrl(event.getUpload().getPublicUrl()));
        }
        BlockAttachment tempAttachment = (BlockAttachment)localFileBlock.getAttachments().get(0);
        tempAttachment = tempAttachment.toBuilder().withSize(event.getSize()).withId(event.getUpload().getId()).build();
        Block.Builder builder = localFileBlock.toBuilder().withAttachments(Collections.singletonList(tempAttachment)).withType(BlockType.ATTACHMENTLIST.getSerializedName());
        return Collections.singletonList(builder);
    }

    @Override
    public void uploadImage(List<Block.Builder> blocks, GalleryImage galleryImage) {
        Part part = this.addSendingPart(blocks);
        part.setUpload(galleryImage);
        this.api.uploadFile(galleryImage, this.parts.size() - 1, part.getId(), this.uploadingImageCache, (UploadProgressListener)this.adapter.getViewForPart(part).getChildAt(0));
    }

    @Override
    public void onNewConversation(NewConversationEvent event) {
        this.updateSendPartOpsMetric();
        Conversation conversation = event.getConversation();
        Part part = event.getConversation().getParts().get(0);
        this.conversationId = conversation.getId();
        this.parts.remove(this.parts.size() - 1);
        this.sendingParts.clear();
        this.addViewForPart(part);
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        this.soundPlayer.playReplyDeliveredSound();
    }

    @Override
    public void onReplyDelivered(ReplyEvent event) {
        this.updateSendPartOpsMetric();
        final Part part = event.getResponse();
        int position = this.positionOfPart(event.getPosition(), event.getPartId());
        if (position >= 0) {
            this.sendingParts.remove(this.parts.remove(position));
        }
        this.addViewForPart(part);
        part.setDisplayDelivered(true);
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        this.soundPlayer.playReplyDeliveredSound();
        this.conversationList.removeCallbacks(this.replyDeliveredUpdater);
        this.replyDeliveredUpdater = new Runnable(){

            @Override
            public void run() {
                part.setDisplayDelivered(false);
                NativeConversationContentPresenter.this.adapter.notifyDataSetChanged();
            }
        };
        this.conversationList.postDelayed(this.replyDeliveredUpdater, PART_DISPLAY_DELIVERED_TIMEOUT);
    }

    private void updateSendPartOpsMetric() {
        this.opsMetricTracker.trackEvent("finish", "time-to-complete-request-send-part-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-render-result-send-part-ms");
        this.conversationList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                NativeConversationContentPresenter.this.opsMetricTracker.trackEvent("finish", "time-to-render-result-send-part-ms");
                ViewUtils.removeGlobalLayoutListener((View)NativeConversationContentPresenter.this.conversationList, this);
            }
        });
    }

    @Override
    public void onConversationFetched(ConversationEvent event) {
        this.opsMetricTracker.trackEvent("finish", "time-to-complete-request-load-conversation-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-render-result-load-conversation-ms");
        Conversation conversation = event.getResponse();
        this.parts.clear();
        for (Part part : conversation.getParts()) {
            if (this.adapter.getViewForPart(part) == null) {
                this.addViewForPart(part);
            }
            this.parts.add(part);
        }
        this.parts.addAll(this.sendingParts);
        this.timestampAdder.addDayDividers(this.parts);
        this.adapter.notifyDataSetChanged();
        this.conversationList.postDelayed(this.timestampUpdater, TIMESTAMP_UPDATE_PERIOD);
        this.conversationList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                NativeConversationContentPresenter.this.opsMetricTracker.trackEvent("finish", "time-to-render-result-load-conversation-ms");
                ViewUtils.removeGlobalLayoutListener((View)NativeConversationContentPresenter.this.conversationList, this);
            }
        });
    }

    @Subscribe
    public void onUserContentSeenByAdmin(UserContentSeenByAdminEvent event) {
        if (event.getConversationId().equals(this.conversationId) && !this.parts.isEmpty()) {
            boolean markedAsSeen = false;
            for (int i = this.parts.size() - 1; i >= 0; --i) {
                Part part = this.parts.get(i);
                if (!markedAsSeen && !part.isAdmin()) {
                    part.setSeenByAdmin("seen");
                    markedAsSeen = true;
                    continue;
                }
                part.setSeenByAdmin("hide");
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    public void cleanup() {
        this.conversationList.removeCallbacks(this.replyDeliveredUpdater);
        this.conversationList.removeCallbacks(this.timestampUpdater);
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.parts.isEmpty() && this.parts.get(this.parts.size() - 1).getId().equals(event.getPartId())) {
            this.onNewConversation(event);
            this.host.onConversationCreated(event.getConversation(), event.isAnnotatedImage());
        }
    }
}

