/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.support.annotation.VisibleForTesting;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.blockInterfaces.ConversationRatingBlock;
import io.intercom.android.sdk.blocks.models.ConversationRating;
import io.intercom.android.sdk.blocks.models.ConversationRatingOption;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.imageloader.LongTermImageLoader;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.util.ArrayList;
import java.util.List;

public class ConversationRatingCard
implements ConversationRatingBlock {
    private static final float SELECTED_RATING_SCALE = 1.2f;
    private static final float DESELECTED_RATING_SCALE = 1.0f;
    private static final float RATING_HORIZONTAL_PADDING = 17.0f;
    private static final float RATING_VERTICAL_PADDING = 14.0f;
    private static final long ANIMATION_DURATION_MS = 200L;
    private final Api api;
    private final String conversationId;
    private final ColorFilter deselectedFilter;
    private final List<ImageView> ratingViews;
    private LongTermImageLoader longTermImageLoader;
    private ConversationRating conversationRating;
    private final View.OnClickListener ratingClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            int viewIndex = ConversationRatingCard.this.ratingViews.indexOf(v);
            if (viewIndex == -1 || ConversationRatingCard.this.ratingViews.size() != ConversationRatingCard.this.conversationRating.getOptions().size()) {
                return;
            }
            ConversationRatingCard.this.rateConversation(ConversationRatingCard.this.conversationRating, (ConversationRatingOption)ConversationRatingCard.this.conversationRating.getOptions().get(viewIndex));
            ConversationRatingCard.this.updateSelectedRating();
        }
    };

    ConversationRatingCard(Api api, String conversationId) {
        this.api = api;
        this.conversationId = conversationId;
        this.ratingViews = new ArrayList<ImageView>();
        this.deselectedFilter = ColorUtils.newGreyscaleFilter();
    }

    public View addConversationRatingBlock(ConversationRating conversationRating, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        return this.createConversationRatingBlock(conversationRating, parent);
    }

    private View createConversationRatingBlock(ConversationRating conversationRating, ViewGroup parent) {
        Context context = parent.getContext();
        this.ratingViews.clear();
        this.conversationRating = conversationRating;
        this.longTermImageLoader = LongTermImageLoader.newInstance(context);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        LinearLayout rootLayout = (LinearLayout)layoutInflater.inflate(R.layout.intercom_conversation_rating_block, parent, false);
        LinearLayout ratingsLayout = (LinearLayout)rootLayout.findViewById(R.id.intercom_rating_options_layout);
        int verticalMargin = ScreenUtils.dpToPx((float)14.0f, (Context)context);
        int horizontalMargin = ScreenUtils.dpToPx((float)17.0f, (Context)context);
        for (int i = 0; i < conversationRating.getOptions().size(); ++i) {
            ConversationRatingOption option = (ConversationRatingOption)conversationRating.getOptions().get(i);
            FrameLayout frameLayout = new FrameLayout(context);
            frameLayout.setClipChildren(false);
            frameLayout.setClipToPadding(false);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            final ImageView ratingView = new ImageView(context);
            int imageSizePx = context.getResources().getDimensionPixelSize(R.dimen.intercom_conversation_rating_size);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(imageSizePx, imageSizePx, 17);
            layoutParams.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            ratingView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ratingView.setLongClickable(false);
            String imageUrl = ConversationRatingCard.imageUrlForUnicode(option.getUnicode());
            this.longTermImageLoader.loadImage(imageUrl, context, new LongTermImageLoader.OnImageReadyListener(){

                @Override
                public void onImageReady(Bitmap bitmap) {
                    ratingView.setImageBitmap(bitmap);
                }
            });
            ratingView.setOnClickListener(this.ratingClickListener);
            frameLayout.addView((View)ratingView);
            ratingsLayout.addView((View)frameLayout);
            this.ratingViews.add(ratingView);
        }
        this.updateSelectedRating();
        return rootLayout;
    }

    @VisibleForTesting
    void rateConversation(ConversationRating conversationRating, ConversationRatingOption conversationRatingOption) {
        conversationRating.setRatingIndex(conversationRatingOption.getIndex().intValue());
        this.api.rateConversation(this.conversationId, conversationRatingOption.getIndex());
    }

    private void updateSelectedRating() {
        if (this.conversationRating.getOptions().size() != this.ratingViews.size()) {
            return;
        }
        for (int i = 0; i < this.conversationRating.getOptions().size(); ++i) {
            ConversationRatingOption option = (ConversationRatingOption)this.conversationRating.getOptions().get(i);
            ImageView ratingView = this.ratingViews.get(i);
            if (this.conversationRating.getRatingIndex() == -1) {
                this.selectView(1.0f, ratingView);
                continue;
            }
            if (this.conversationRating.getRatingIndex() == option.getIndex()) {
                this.selectView(1.2f, ratingView);
                continue;
            }
            this.deselectView(ratingView);
        }
    }

    private void selectView(float scale, ImageView ratingView) {
        ratingView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(2.0f)).scaleX(scale).scaleY(scale).setDuration(200L).start();
        ratingView.clearColorFilter();
    }

    private void deselectView(ImageView ratingView) {
        ratingView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).scaleX(1.0f).scaleY(1.0f).setDuration(200L).start();
        ratingView.setColorFilter(this.deselectedFilter);
    }

    private static String imageUrlForUnicode(String unicode) {
        return "https://js.intercomcdn.com/images/stickers/" + unicode + ".png";
    }
}

