/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.JsCoreWebViewClient;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.conversation.WebViewConversationAction;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;

public class JsCore {
    private static final String WEB_PAGE_URL = "file:///android_asset/core.html";
    private final JavascriptRunner javascriptRunner;
    private final Gson gson;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static JsCore create(Context context, AppIdentity appIdentity, Provider<UserIdentity> userIdentity, Gson gson) {
        WebView webView = new WebView(context);
        JavascriptRunner javascriptRunner = new JavascriptRunner(webView);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.setWebViewClient((WebViewClient)new JsCoreWebViewClient(javascriptRunner));
        webView.loadUrl(WEB_PAGE_URL);
        JsCore api = new JsCore(javascriptRunner, gson);
        api.sendWebViewAction(WebViewConversationAction.setUser(appIdentity, userIdentity.get()));
        return api;
    }

    public JsCore(JavascriptRunner javascriptRunner, Gson gson) {
        this.javascriptRunner = javascriptRunner;
        this.gson = gson;
    }

    void sendWebViewAction(WebViewConversationAction action) {
        this.javascriptRunner.run("core.handleAction(" + this.gson.toJson((Object)action) + ");");
    }

    public void logEvent(String name, Map<String, ?> metaData) {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("name", name);
        value.put("metadata", metaData);
        this.sendWebViewAction(new WebViewConversationAction("LOG_EVENT", value));
    }
}

