/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;

class TeammateProfileToolbarBehavior
extends ProfileToolbarBehavior {
    private static final float CHANGE_IN_AVATAR_SCALE = 0.5f;
    private static final float CHANGE_IN_TITLE_SCALE = 0.1f;
    private final float translate8dp;
    private final float translate18dp;
    private final float profileTranslationY;
    private final float maxAlpha;
    private final ViewGroup rootLayout;
    @Nullable
    private View avatar1;
    @Nullable
    private View avatar2;
    @Nullable
    private View avatar3;
    @Nullable
    private View activeStateCircle;
    @Nullable
    private View title;
    @Nullable
    private View subtitle;
    @Nullable
    private View role;
    @Nullable
    private View location;
    @Nullable
    private View bio;
    @Nullable
    private LinearLayout socialLayout;
    @Nullable
    private ImageView backgroundView;

    TeammateProfileToolbarBehavior(ViewGroup rootLayout) {
        super(rootLayout.getContext());
        this.rootLayout = rootLayout;
        Context context = rootLayout.getContext();
        this.translate8dp = ScreenUtils.dpToPx((float)8.0f, (Context)context);
        this.profileTranslationY = context.getResources().getDimensionPixelSize(R.dimen.intercom_team_profile_translation_y);
        this.translate18dp = ScreenUtils.dpToPx((float)18.0f, (Context)context);
        TypedValue outValue = new TypedValue();
        context.getResources().getValue(R.dimen.intercom_toolbar_image_background_alpha, outValue, true);
        this.maxAlpha = outValue.getFloat();
    }

    private void updateSocialButtons(ViewGroup child, View dependency) {
        if (this.socialLayout == null) {
            this.socialLayout = (LinearLayout)child.findViewById(R.id.social_button_layout);
        }
        this.translateY((View)this.socialLayout, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll((View)this.socialLayout, dependency, 1.0f, false);
    }

    private void updateRole(ViewGroup child, View dependency) {
        if (this.role == null) {
            this.role = child.findViewById(R.id.intercom_collapsing_role);
        }
        this.translateY(this.role, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll(this.role, dependency, 1.0f, false);
    }

    private void updateLocation(ViewGroup child, View dependency) {
        if (this.location == null) {
            this.location = child.findViewById(R.id.intercom_collapsing_location);
        }
        this.translateY(this.location, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll(this.location, dependency, 1.0f, false);
    }

    private void updateBio(ViewGroup child, View dependency) {
        if (this.bio == null) {
            this.bio = child.findViewById(R.id.intercom_collapsing_bio);
        }
        this.translateY(this.bio, dependency, this.profileTranslationY);
        this.setAlphaAsPercentageOfScroll(this.bio, dependency, 0.7f, false);
    }

    private void updateTitle(ViewGroup child, View dependency, float scrollPercentage) {
        float translationYSubtitle;
        float newTransYSubtitle;
        if (this.title == null) {
            this.title = child.findViewById(R.id.intercom_collapsing_title);
        }
        if (this.subtitle == null) {
            this.subtitle = child.findViewById(R.id.intercom_collapsing_subtitle);
        }
        this.setAlphaAsPercentageOfScroll(this.subtitle, dependency, 1.0f, false);
        float translationY = (float)(ScreenUtils.dpToPx((float)7.0f, (Context)dependency.getContext()) / 100) * scrollPercentage;
        float newTransY = (int)Math.max(0.0f, translationY);
        if (newTransY > 0.0f) {
            this.title.setTranslationY(newTransY);
        }
        if ((newTransYSubtitle = (float)((int)Math.max(0.0f, translationYSubtitle = this.translate18dp / 100.0f * scrollPercentage))) > 0.0f) {
            this.subtitle.setTranslationY(newTransYSubtitle);
        }
        float scale = 1.0f + 0.001f * scrollPercentage;
        this.title.setPivotX(0.0f);
        this.title.setPivotY(0.0f);
        this.title.setScaleX(scale);
        this.title.setScaleY(scale);
    }

    private void updateAvatar(ViewGroup child, View dependency, float scrollPercentage) {
        if (this.avatar1 == null) {
            this.avatar1 = child.findViewById(R.id.intercom_collapsing_teammate_avatar1);
        }
        if (this.avatar2 == null) {
            this.avatar2 = child.findViewById(R.id.intercom_collapsing_teammate_avatar2);
        }
        if (this.avatar3 == null) {
            this.avatar3 = child.findViewById(R.id.intercom_collapsing_teammate_avatar3);
        }
        if (this.activeStateCircle == null) {
            this.activeStateCircle = child.findViewById(R.id.intercom_collapsing_teammate_active_state);
        }
        Resources res = child.getContext().getResources();
        float avatarSize = res.getDimensionPixelSize(R.dimen.intercom_teammate_avatar_size);
        float activeStateSize = res.getDimensionPixelSize(R.dimen.intercom_teammate_active_state_size);
        float xFactor = 1.0f + (1.0f - activeStateSize / avatarSize);
        float yFactor = 1.0f + activeStateSize / avatarSize;
        float translationX = this.translate8dp / 100.0f * scrollPercentage;
        this.avatar1.setTranslationX((float)((int)Math.max(translationX, 0.0f)));
        this.activeStateCircle.setTranslationX((float)((int)Math.max(translationX * xFactor, 0.0f)));
        float translationY = this.profileTranslationY / 100.0f * scrollPercentage;
        this.avatar1.setTranslationY((float)((int)Math.max(0.0f, translationY)));
        this.activeStateCircle.setTranslationY((float)((int)Math.max(0.0f, translationY * yFactor)));
        float scale = 1.0f + 0.005f * scrollPercentage;
        this.avatar1.setScaleX(scale);
        this.avatar1.setScaleY(scale);
        this.activeStateCircle.setScaleX(scale);
        this.activeStateCircle.setScaleY(scale);
        this.setAlphaAsPercentageOfScroll(this.avatar2, dependency, 1.0f, true);
        this.setAlphaAsPercentageOfScroll(this.avatar3, dependency, 1.0f, true);
    }

    private void updateBackgroundImage(ViewGroup child, View dependency) {
        if (this.backgroundView == null) {
            this.backgroundView = (ImageView)child.findViewById(R.id.collapsing_background_image);
        }
        this.setAlphaAsPercentageOfScroll((View)this.backgroundView, dependency, this.maxAlpha, false);
    }

    public void onOffsetChanged(AppBarLayout appBarLayout, int verticalOffset) {
        boolean isInLayoutPass = false;
        if (Build.VERSION.SDK_INT >= 18) {
            isInLayoutPass = this.rootLayout.isInLayout();
        }
        if ((float)appBarLayout.getHeight() <= this.toolbarHeight || isInLayoutPass) {
            return;
        }
        float scrollPercentage = this.getScrollPercentage((View)appBarLayout);
        this.rootLayout.getLayoutParams().height = appBarLayout.getBottom();
        this.updateAvatar(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateTitle(this.rootLayout, (View)appBarLayout, scrollPercentage);
        this.updateRole(this.rootLayout, (View)appBarLayout);
        this.updateLocation(this.rootLayout, (View)appBarLayout);
        this.updateBio(this.rootLayout, (View)appBarLayout);
        this.updateSocialButtons(this.rootLayout, (View)appBarLayout);
        this.updateBackgroundImage(this.rootLayout, (View)appBarLayout);
        this.rootLayout.requestLayout();
    }

    private void translateY(View child, View dependency, float totalYTranslation) {
        float translation = totalYTranslation / 100.0f * this.getScrollPercentage(dependency);
        child.setTranslationY((float)((int)Math.max(0.0f, translation)));
    }
}

