/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReadResponse;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.state.ReplyPart;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.retrofit2.Callback;

class CallbackHolder {
    final Bus bus;
    final Store<State> store;

    CallbackHolder(Bus bus, Store<State> store) {
        this.bus = bus;
        this.store = store;
    }

    BaseCallback<ReadResponse.Builder> readCallback() {
        return new BaseCallback<ReadResponse.Builder>(){

            @Override
            public void onSuccess(ReadResponse.Builder builder) {
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(builder.build()));
            }
        };
    }

    BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder builder) {
                UsersResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
            }
        };
    }

    Callback<ConversationsResponse.Builder> inboxCallback() {
        return new BaseCallback<ConversationsResponse.Builder>(){

            @Override
            public void onSuccess(ConversationsResponse.Builder builder) {
                ConversationsResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.fetchInboxSuccess(response));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.store.dispatch(Actions.fetchInboxFailed());
            }
        };
    }

    Callback<Part.Builder> replyCallback(final int position, final boolean isUpload, final String partId, final String conversationId, final boolean isAnnotated) {
        return new BaseCallback<Part.Builder>(){

            @Override
            public void onSuccess(Part.Builder builder) {
                Part response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.conversationReplySuccess(new ReplyPart(response, conversationId)));
                CallbackHolder.this.bus.post((Object)new ReplyEvent(response, position, partId, conversationId, isAnnotated));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new ReplyFailedEvent(position, isUpload, partId));
            }
        };
    }

    Callback<Conversation.Builder> conversationCallback() {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                CallbackHolder.this.store.dispatch(Actions.fetchConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new ConversationEvent(conversation));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new ConversationFailedEvent());
            }
        };
    }

    Callback<Conversation.Builder> newConversationCallback(final int position, final String partId, final boolean isAnnotatedImage) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                CallbackHolder.this.store.dispatch(Actions.newConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new NewConversationEvent(conversation, partId, isAnnotatedImage));
            }

            @Override
            protected void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }
}

