/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.AuthorAvatarView;

class InboxRowViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    private final TextView authorName;
    private final TextView timeStamp;
    private final TextView summary;
    private final ImageView conversationIndicator;
    private final AuthorAvatarView authorAvatar;
    private final ConversationClickListener conversationClickListener;
    private final TimeFormatter timeFormatter;

    InboxRowViewHolder(View itemView, ConversationClickListener conversationClickListener, TimeFormatter timeFormatter) {
        super(itemView);
        this.conversationClickListener = conversationClickListener;
        this.timeFormatter = timeFormatter;
        itemView.setOnClickListener((View.OnClickListener)this);
        this.authorAvatar = (AuthorAvatarView)itemView.findViewById(R.id.intercom_author_avatar);
        this.authorName = (TextView)itemView.findViewById(R.id.intercom_user_name);
        this.timeStamp = (TextView)itemView.findViewById(R.id.intercom_time_stamp);
        this.summary = (TextView)itemView.findViewById(R.id.intercom_message_summary);
        this.conversationIndicator = (ImageView)itemView.findViewById(R.id.intercom_conversation_indicator);
    }

    void bindData(Conversation conversation, UserIdentity userIdentity, AppConfig appConfig, TeamPresence teamPresence) {
        Part lastPart = conversation.getLastPart();
        Context context = this.itemView.getContext();
        if (lastPart.getParticipant().isUserWithId(userIdentity.getIntercomId())) {
            this.summary.setText((CharSequence)(context.getString(R.string.intercom_you) + ": " + lastPart.getSummary()));
        } else {
            this.summary.setText((CharSequence)lastPart.getSummary());
        }
        this.timeStamp.setText(this.timeFormatter.getFormattedTime(lastPart.getCreatedAt()));
        this.setRowParticipantDetails(conversation, appConfig.getName(), teamPresence, appConfig);
        if (!conversation.isRead()) {
            FontUtils.setRobotoMediumTypeface(this.authorName);
            this.summary.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_800));
            Drawable unreadDot = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_unread_dot);
            int baseColor = appConfig.getBaseColor();
            ((GradientDrawable)unreadDot).setColor(baseColor);
            this.timeStamp.setCompoundDrawablesWithIntrinsicBounds(unreadDot, null, null, null);
            this.timeStamp.setTextColor(baseColor);
        } else {
            this.authorName.setTypeface(Typeface.SANS_SERIF);
            this.summary.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_600));
            this.timeStamp.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            this.timeStamp.setTextColor(ContextCompat.getColor((Context)context, (int)R.color.intercom_grey_500));
        }
        if (conversation.isUserParticipated()) {
            this.conversationIndicator.setVisibility(0);
        } else {
            this.conversationIndicator.setVisibility(4);
        }
    }

    private void setRowParticipantDetails(Conversation conversation, String appName, TeamPresence teamPresence, AppConfig appConfig) {
        LastParticipatingAdmin admin = conversation.getLastParticipatingAdmin();
        if (!TextUtils.isEmpty((CharSequence)admin.getFirstName())) {
            this.authorAvatar.loadAvatarWithActiveState(admin.getAvatar(), admin.isActive(), appConfig);
            this.authorName.setText((CharSequence)InboxRowViewHolder.formatAdmin(admin));
        } else if (teamPresence.isEmpty()) {
            this.authorAvatar.loadAvatar(admin.getAvatar(), appConfig);
            this.authorName.setText((CharSequence)appName);
        } else {
            this.authorAvatar.loadAvatars(teamPresence.getActiveAdmins(), appConfig);
            this.authorName.setText((CharSequence)appName);
        }
    }

    @VisibleForTesting
    static String formatAdmin(LastParticipatingAdmin admin) {
        String firstName = admin.getFirstName();
        int firstSpaceIndex = firstName.indexOf(32);
        if (firstSpaceIndex == -1) {
            return firstName;
        }
        return firstName.substring(0, firstSpaceIndex);
    }

    public void onClick(View v) {
        int index = this.getAdapterPosition();
        if (index != -1) {
            this.conversationClickListener.onConversationClicked(index);
        }
    }
}

