/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.net.Uri;
import android.os.Environment;
import android.os.FileObserver;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.overlay.ScreenshotEventListener;

public class ScreenshotObserver
extends FileObserver {
    private static final String EXPECTED_FOLDER_PATH = Environment.getExternalStorageDirectory().toString() + "/Pictures/Screenshots/";
    private static final String FILE_SCHEME = "file://";
    private static final int DEATH_EVENT = 32768;
    private final ScreenshotEventListener listener;
    private final String folderPath;
    private boolean started = false;
    private String lastCreatedFilePath = "";

    public ScreenshotObserver(ScreenshotEventListener listener) {
        this(EXPECTED_FOLDER_PATH, listener);
    }

    @VisibleForTesting
    ScreenshotObserver(String folderPath, ScreenshotEventListener listener) {
        super(folderPath, 3912);
        this.folderPath = folderPath;
        this.listener = listener;
    }

    public void onEvent(int event, @Nullable String filePath) {
        switch (event) {
            case 256: {
                if (filePath == null || filePath.equals(this.lastCreatedFilePath)) break;
                this.lastCreatedFilePath = filePath;
                break;
            }
            case 8: {
                if (filePath == null || !filePath.equals(this.lastCreatedFilePath)) break;
                this.lastCreatedFilePath = "";
                this.listener.onScreenshotTaken(this.createUri(filePath));
                break;
            }
            case 64: 
            case 512: {
                if (filePath == null) break;
                this.listener.onScreenshotDeleted(this.createUri(filePath));
                break;
            }
            case 1024: 
            case 2048: {
                this.listener.onScreenshotFolderDeleted();
                break;
            }
            case 32768: {
                if (!this.started) break;
                this.stopWatching();
                this.startWatching();
                break;
            }
        }
    }

    public void startWatching() {
        this.started = true;
        super.startWatching();
    }

    public void stopWatching() {
        super.stopWatching();
        this.started = false;
    }

    private Uri createUri(String filePath) {
        return Uri.parse((String)(FILE_SCHEME + this.folderPath + filePath));
    }
}

