/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.List;

public class TeamPresence {
    private final List<Participant> activeAdmins;
    private final String expectedResponseDelay;
    private final String officeHours;

    TeamPresence(Builder builder) {
        this.activeAdmins = new ArrayList<Participant>(CollectionUtils.capacityFor(builder.active_admins));
        if (builder.active_admins != null) {
            for (Participant.Builder participantBuilder : builder.active_admins) {
                if (participantBuilder == null) continue;
                this.activeAdmins.add(participantBuilder.build());
            }
        }
        this.expectedResponseDelay = NullSafety.valueOrEmpty(builder.expected_response_delay);
        this.officeHours = NullSafety.valueOrEmpty(builder.office_hours);
    }

    public List<Participant> getActiveAdmins() {
        return this.activeAdmins;
    }

    public boolean isEmpty() {
        return this.activeAdmins.isEmpty() && this.expectedResponseDelay.isEmpty();
    }

    public String getExpectedResponseDelay() {
        return this.expectedResponseDelay;
    }

    public String getOfficeHours() {
        return this.officeHours;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeamPresence that = (TeamPresence)o;
        if (!this.activeAdmins.equals(that.activeAdmins)) {
            return false;
        }
        if (!this.expectedResponseDelay.equals(that.expectedResponseDelay)) {
            return false;
        }
        return this.officeHours.equals(that.officeHours);
    }

    public int hashCode() {
        int result = this.activeAdmins.hashCode();
        result = 31 * result + this.expectedResponseDelay.hashCode();
        result = 31 * result + this.officeHours.hashCode();
        return result;
    }

    public static final class Builder {
        List<Participant.Builder> active_admins;
        String expected_response_delay;
        String office_hours;

        public TeamPresence build() {
            return new TeamPresence(this);
        }
    }
}

