/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.blockInterfaces.LocalImageBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.views.ProgressFrameLayout;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.android.sdk.views.UploadProgressBar;
import io.intercom.com.bumptech.glide.DrawableTypeRequest;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;

class LocalImage
extends Image
implements LocalImageBlock {
    private final Twig twig = LumberMill.getLogger();

    LocalImage(StyleType style) {
        super(style);
    }

    public View addImage(String url, int width, int height, BlockAlignment alignment, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        Context context = parent.getContext();
        int widthPx = ScreenUtils.dpToPx((float)width, (Context)context);
        int heightPx = ScreenUtils.dpToPx((float)height, (Context)context);
        ProgressFrameLayout rootView = new ProgressFrameLayout(context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        final ResizableImageView imageView = new ResizableImageView(context);
        BlockUtils.createLayoutParams((View)imageView, -2, -2);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        rootView.addView((View)imageView);
        DrawableTypeRequest requestCreator = Glide.with((Context)context).load(url);
        this.setImageViewBounds(widthPx, heightPx, imageView, requestCreator);
        View view = rootView.getChildAt(0);
        Resources resources = context.getResources();
        if (view instanceof UploadProgressBar) {
            int spinnerSize = resources.getDimensionPixelSize(R.dimen.intercom_local_image_upload_size);
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(spinnerSize, spinnerSize, 17));
            view.bringToFront();
            rootView.uploadStarted();
        }
        this.setBackground((ImageView)imageView);
        ColorMatrix matrix = new ColorMatrix();
        matrix.setSaturation(0.0f);
        imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(matrix));
        requestCreator.bitmapTransform(new Transformation[]{new RoundedCornersTransform(context, resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners))}).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                LocalImage.this.twig.internal("images", "FAILURE");
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                LocalImage.this.twig.internal("images", "SUCCESS");
                imageView.setBackgroundResource(17170445);
                return false;
            }
        }).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(url)).into((ImageView)imageView);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), isLastObject);
        return rootView;
    }
}

