/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.graphics.PorterDuff;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.webkit.WebView;
import android.widget.ProgressBar;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.ConversationWebViewClient;
import io.intercom.android.sdk.conversation.IntercomLinkPresenter;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.conversation.ObservableWebView;
import io.intercom.android.sdk.conversation.WebViewConversationAction;
import io.intercom.android.sdk.conversation.WebViewHostWrapper;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.realtime.NewCommentEvent;
import io.intercom.android.sdk.profile.ProfilePresenter;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;
import java.util.List;

class WebViewConversationContentPresenter
implements ConversationContentPresenter,
IntercomLinkPresenter.IntercomLinkHost {
    private static final String WEB_PAGE_URL = "https://js.intercomcdn.com/mobile.html";
    private static final int DIRECTION_DOWN = 1;
    private final ObservableWebView webView;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;
    private final Provider<AppConfig> appConfigProvider;
    private final ConversationContentPresenter.Host host;
    private final Gson gson;
    private final JavascriptRunner jsRunner;
    private final View loadingView;
    private WebViewHostWrapper hostWrapper;
    private final Store<State> store;
    private final Bus bus;
    private final IntercomLinkPresenter intercomLinkPresenter;
    private final List<Part> parts;
    private final OpsMetricTracker opsMetricTracker;
    private final ProfilePresenter profilePresenter;
    private boolean fetchedConversation = false;

    static WebViewConversationContentPresenter create(ObservableWebView webView, View loadingView, IntercomLinkView intercomLinkView, AppIdentity appIdentity, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider, Api api, List<Part> parts, String conversationId, ConversationContentPresenter.Host host, Gson gson, JavascriptRunner jsRunner, Store<State> store, Bus bus, OpsMetricTracker opsMetricTracker, ProfilePresenter profilePresenter) {
        IntercomLinkPresenter linkPresenter = new IntercomLinkPresenter(intercomLinkView, appConfigProvider, api, parts, conversationId);
        return new WebViewConversationContentPresenter(webView, loadingView, linkPresenter, appIdentity, userIdentity, appConfigProvider, parts, host, gson, jsRunner, store, bus, opsMetricTracker, profilePresenter);
    }

    @VisibleForTesting
    WebViewConversationContentPresenter(ObservableWebView webView, View loadingView, IntercomLinkPresenter intercomLinkPresenter, AppIdentity appIdentity, UserIdentity userIdentity, Provider<AppConfig> appConfigProvider, List<Part> parts, ConversationContentPresenter.Host host, Gson gson, JavascriptRunner jsRunner, Store<State> store, Bus bus, OpsMetricTracker opsMetricTracker, ProfilePresenter profilePresenter) {
        this.webView = webView;
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
        this.appConfigProvider = appConfigProvider;
        this.host = host;
        this.gson = gson;
        this.jsRunner = jsRunner;
        this.loadingView = loadingView;
        this.store = store;
        this.bus = bus;
        this.intercomLinkPresenter = intercomLinkPresenter;
        this.parts = parts;
        this.opsMetricTracker = opsMetricTracker;
        this.profilePresenter = profilePresenter;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setup() {
        this.webView.setOnScrollChangeListener(new ObservableWebView.OnScrollChangeListener(){

            @Override
            public void onScrollChange(WebView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                if (scrollY > 0 && WebViewConversationContentPresenter.this.profilePresenter.isExpanded()) {
                    WebViewConversationContentPresenter.this.profilePresenter.flingProfileClosed();
                }
                WebViewConversationContentPresenter.this.intercomLinkPresenter.updateIntercomLink(WebViewConversationContentPresenter.this);
            }
        });
        AppConfig appConfig = this.appConfigProvider.get();
        ProgressBar progressBar = (ProgressBar)this.loadingView.findViewById(R.id.progressBar);
        if (progressBar != null) {
            progressBar.getIndeterminateDrawable().setColorFilter(appConfig.getBaseColor(), PorterDuff.Mode.SRC_IN);
        }
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new ConversationWebViewClient(this.jsRunner, WEB_PAGE_URL, this.bus));
        this.hostWrapper = new WebViewHostWrapper(this.host, this.webView, this.gson, this.store, this.parts, this.opsMetricTracker);
        this.webView.addJavascriptInterface(this.hostWrapper, "AndroidHost");
        this.webView.setBackgroundColor(0);
        this.intercomLinkPresenter.setup(this);
    }

    private void loadBundle() {
        this.jsRunner.reset();
        this.jsRunner.run("conversationApp.sendAction = function(action) {AndroidHost.handleAction(JSON.stringify(action));};");
        this.webView.loadUrl(WEB_PAGE_URL);
    }

    @VisibleForTesting
    void sendWebViewAction(WebViewConversationAction action) {
        String actionJson = this.gson.toJson((Object)action);
        this.jsRunner.run("conversationApp.handleAction(" + actionJson + ");");
    }

    @Override
    public void smoothScrollToTop() {
        this.scrollToTop();
    }

    @Override
    public void scrollToTop() {
        this.webView.scrollTo(0, 0);
    }

    @Override
    public void scrollToBottom() {
        this.webView.scrollTo(0, (int)((float)this.webView.getContentHeight() * this.webView.getScale()));
    }

    @Override
    public boolean isAtBottom() {
        return !this.webView.canScrollVertically(1);
    }

    @Override
    public void onProfileScrolled() {
        if (this.profilePresenter.isExpanded()) {
            this.scrollToTop();
        }
        this.intercomLinkPresenter.updateIntercomLink(this);
    }

    @Override
    public void onGlobalLayout() {
        this.intercomLinkPresenter.updateIntercomLink(this);
    }

    @Override
    public void onNewPartReceived() {
    }

    @Override
    public void showErrorView() {
        this.loadingView.setVisibility(8);
        this.webView.setVisibility(4);
        this.fetchedConversation = false;
    }

    @Override
    public void showLoadingView() {
        this.loadingView.setVisibility(0);
        this.webView.setVisibility(4);
    }

    @Override
    public void showContentView() {
        this.webView.setVisibility(0);
        this.loadingView.setVisibility(8);
    }

    @Override
    public void onAdminStartedTyping(AdminIsTypingEvent event) {
        this.sendWebViewAction(WebViewConversationAction.adminIsTyping(event.getAdminId(), event.getAdminName(), event.getAdminAvatarUrl()));
    }

    @Override
    public void onNewCommentEventReceived(NewCommentEvent event) {
        this.sendWebViewAction(WebViewConversationAction.partCreated());
    }

    @Override
    public void fetchConversation(String conversationId) {
        if (this.fetchedConversation) {
            return;
        }
        this.fetchedConversation = true;
        this.loadBundle();
        this.sendWebViewAction(WebViewConversationAction.setConversation(this.appIdentity, this.userIdentity, this.appConfigProvider, conversationId));
    }

    @Override
    public void onPartClicked(Part part) {
    }

    @Override
    public void sendPart(List<Block.Builder> blockBuilders) {
        this.sendWebViewAction(WebViewConversationAction.createPart(blockBuilders));
    }

    @Override
    public void uploadImage(List<Block.Builder> blocks, GalleryImage galleryImage) {
        this.sendWebViewAction(WebViewConversationAction.createUpload(galleryImage.getFileName(), galleryImage.getPath(), galleryImage.getMimeType(), galleryImage.getImageWidth(), galleryImage.getImageHeight(), galleryImage.isAnnotated()));
    }

    @Override
    public void onNewConversation(NewConversationEvent event) {
    }

    @Override
    public void onReplyDelivered(ReplyEvent event) {
    }

    @Override
    public void onConversationFetched(ConversationEvent event) {
    }

    @Override
    public void cleanup() {
        this.jsRunner.clearPendingScripts();
    }

    @Override
    public void addBottomPadding(int extraBottomPadding) {
    }
}

